<!-- scv/resources/views/apppath/edit.blade.php -->
@extends('layout.default')
@section('content')
@section('head')
<link rel="stylesheet" href="{{ asset('/css/applist-style.css') }}">
<script type="text/javascript" src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
<script src="{!! asset('js/bootstrap.min.js') !!}"></script>
<script src="{!! asset('js/scvmanager/moveAppPath.js') !!}"></script>
@endsection 

<div class="page-header">
  <h3>アプリケーションパス編集<span class="revodt-icon"></span></h3>
</div>

<div class="page_discription">
  <h4>アプリケーション名: {{$app_name}}</h4>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

{{ Form::open(['url' => '/scvmanager/apppath/store', 'method' => 'post', 'class' => 'pathlist_form']) }}
<input type="hidden" name="app_id" value="{{$app_id}}"/>
<input type="hidden" name="app_name" value="{{$app_name}}"/>
<div class="applist_column">
  <button type="button" onclick="location.href='{{URL::to('/scvmanager/appsettings')}}'">戻る</button>
  {{ Form::submit('保存') }}
</div>

<div class="add_area">
  <input type='text' name="add_pathname"/>
  <button type="button" id="add_button">追加</button>
</div>

<div class="applist_content">
  <div class="new_list">
    <div class="list_description">
      <p>追加するアプリケーションパス</p>
      <div class="sort_button">
        <button type="button" id="left_asc">
          <img src="{{ asset('css/images/black-asc.gif') }}"/>
        </button>

        <button type="button" id="left_desc">
          <img src="{{ asset('css/images/black-desc.gif') }}"/>
        </button>
      </div>
    </div>
    <select id="left_list" size="12" multiple>
      @if (!empty($app_paths))
        @foreach ($app_paths as $path)
         <option value="{{$path}}">{{$path}}</option>
        @endforeach
      @endif
    </select>
  </div>
  
  <div class="button_area">
    <p>選択した項目を</p>
    <input type="button" id="to_left" value="登録">
    <input type="button" id="to_right" value="削除">
  </div>
  
  <div class="delete_list">
    <div class="list_description">
      <p>削除するアプリケーションパス</p>
      <div class="sort_button">
        <button type="button" id="right_asc">
          <img src="{{ asset('css/images/black-asc.gif') }}"/>
        </button>

        <button type="button" id="right_desc">
          <img src="{{ asset('css/images/black-desc.gif') }}"/>
        </button>
      </div>
    </div>
    <select id="right_list" size="12" multiple>
      <option disabled value="none">なし</option>
    </select>
  </div>
</div>

{{ Form::hidden('add_paths') }}
{{ Form::hidden('delete_paths') }}
{{ Form::close() }}
@stop

@section('script')
<script src="{!! asset('js/tooltips.js') !!}"></script>
@endsection
