<!-- scv/resources/views/allowapplist/edit.blade.php -->
@extends('layout.default')
@section('content')
@section('head')
<link rel="stylesheet" href="{{ asset('/css/applist-style.css') }}">
<script type="text/javascript" src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
<script src="{!! asset('js/bootstrap.min.js') !!}"></script>
<script src="{!! asset('js/moveAppList.js') !!}"></script>
@endsection 

<div class="page-header">
  <h3>アプリケーションマスタの編集<span class="revodt-icon"></span></h3>
</div>

<div class="page_discription">
  <p></p>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

{{ Form::open(['url' => '/scvmanager/appsettings/store', 'method' => 'post', 'class' => 'applist_form']) }}

<div class="applist_column">
  <button type="button" onclick="location.href='{{URL::to('/scvmanager/appsettings')}}'">戻る</button>
  {{ Form::submit('保存') }}
</div>

<div class="add_area">
  <input type='text' name="add_appname"/>
  <button type="button" id="add_button">追加</button>
</div>

<div class="applist_content">
  <div class="new_list">
    <div class="list_description">
      <p>マスタに登録するアプリケーション名</p>
      <div class="sort_button">
        <button type="button" id="left_asc">
          <img src="{{ asset('css/images/black-asc.gif') }}"/>
        </button>

        <button type="button" id="left_desc">
          <img src="{{ asset('css/images/black-desc.gif') }}"/>
        </button>
      </div>
    </div>
    <select id="left_list" size="12" multiple>
    @if (!empty($appSettings))
      @foreach ($appSettings as $app)
       <option value="{{$app}}">{{$app}}</option>
      @endforeach
    @endif
    </select>
  </div>
  
  <div class="button_area">
    <p>選択した項目を</p>
    <input type="button" id="to_left" value="登録">
    <input type="button" id="to_right" value="削除">
  </div>
  
  <div class="delete_list">
    <div class="list_description">
      <p>マスタから削除するアプリケーション名</p>
      <div class="sort_button">
        <button type="button" id="right_asc">
          <img src="{{ asset('css/images/black-asc.gif') }}"/>
        </button>

        <button type="button" id="right_desc">
          <img src="{{ asset('css/images/black-desc.gif') }}"/>
        </button>
      </div>
    </div>
    <select id="right_list" size="12" multiple>
      <option disabled value="none">なし</option>
    </select>
  </div>
</div>

{{ Form::hidden('allowed_apps') }}
{{ Form::hidden('denied_apps') }}
{{ Form::close() }}
@stop
