<!-- scv/resources/views/allowapplist/show.blade.php -->
@extends('layout.default')
@section('content')
<link rel="stylesheet" href="{{ asset('/css/applist-style.css') }}">
<link rel="stylesheet" href="{{ asset('/css/theme.default.min.css') }}">

<div class="page-header">
  <h3>アプリケーションマスタの管理<span class="revodt-icon"></span></h3>
</div>

<p>デスクトップ設定の許可アプリ設定に使用する、アプリケーションのマスタを設定できます。<br>
<p>現在登録中のアプリケーションマスタは以下の通りです。</p>
@if (!empty($appSettings))
  <p>登録件数:{{count($appSettings)}}</p>
@else
  <p>アプリケーションが登録されていません</p>
@endif
 
@if (Session::has('success'))
  <p class="text-info">{!! Session::get('success') !!}</p>
@endif

<button onclick="location.href='{{URL::to('/scvmanager/appsettings/edit')}}'">マスタ編集</button>
<input type="text" id="list_search" placeholder="検索したいアプリケーション名を入力してください"/>

<div class="table-responsive">
  <table id="app_table" class="table table-condensed table-bordered table-striped tablesorter">
    <thead>
      <tr>
        <th>アプリケーション名</th>
      </tr>
    </thead>
    @if (!empty($appSettings))
      @foreach ($appSettings as $app)
      <tr>
        <td>
          <a href="{{URL::to('/scvmanager/apppath/edit/'.$app->id)}}">{{$app->appname}}</a>
        </td>
      </tr>
      @endforeach
    @else
      <tr>
        <td>登録されているアプリケーションマスタがありません。</td>
      </tr>
    @endif
  </table>
</div>

<div id="no_result">
  <p>その名称のアプリケーションは登録されていません。</p>
</div>

@section('script')
<script src="{!! asset('js/jquery.quicksearch.min.js') !!}"></script>
<script src="{!! asset('js/jquery.tablesorter.min.js') !!}"></script>
<script src="{!! asset('js/searchAppList.js') !!}"></script>
<script>
  $(document).ready(function() {
    $('#app_table').tablesorter({
      headers: {
        1: { sorter: false}
      }
    });
  });
</script>
@endsection
@stop
