<!-- scv/resources/views/allowapplist/show.blade.php -->
<link href="{!! asset('css/bootstrap.min.css') !!}" rel="stylesheet">
<link rel="stylesheet" href="{{ asset('css/scvcommon.css') }}" type="text/css">
<link rel="stylesheet" href="{{ asset('css/theme.default.min.css') }}">
<link rel="stylesheet" href="{{ asset('css/applist-style.css') }}">

<div class="app_master_list">
  <div class="page-header">
    <h3>アプリケーションマスタ一覧<span class="revodt-icon"></span></h3>
    <p>登録中のアプリケーションマスタは以下の通りです。</p>
    @if (!empty($appSettings))
      <p>登録件数:{{count($appSettings)}}</p>
    @else
      <p>アプリケーションが登録されていません</p>
    @endif
    <input type="text" id="list_search" placeholder="検索したいアプリケーション名を入力してください"/>
  </div>
  
  <div class="table-responsive">
    <table id="app_table" class="table table-condensed table-bordered table-striped tablesorter">
      <thead>
        <tr>
          <th>アプリケーション名</th>
        </tr>
      </thead>
      @if (!empty($appSettings))
        @foreach ($appSettings as $app)
        <tr>
          <td>{{$app}}</td>
        </tr>
        @endforeach
      @else
        <tr>
          <td>登録されているアプリケーションマスタがありません。</td>
        </tr>
      @endif
    </table>
  </div>
  
  <div id="no_result">
    <p>その名称のアプリケーションは登録されていません。</p>
  </div>
</div>

<script type="text/javascript" src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
<script src="{!! asset('js/jquery.quicksearch.min.js') !!}"></script>
<script src="{!! asset('js/jquery.tablesorter.min.js') !!}"></script>
<script src="{!! asset('js/bootstrap.min.js') !!}"></script>
<script src="{!! asset('js/searchAppList.js') !!}"></script>
<script>
  $(document).ready(function() {
    $('#app_table').tablesorter();
  });
</script>
