<!-- scv/resources/views/auth/login.blade.php -->
@extends('layout.default')
@section('content')

<?php
use App\Libs\ClusterHelper as CH; ?>

@if((CH::isCluster() && CH::isMaster()) || !CH::isCluster())
<div class="page-header">
  <h3>ログイン</h3>
</div>
<p>
  <font color=red>SCV Managerを利用するには管理者IDでログインしてください。</font>
</p>
@if(session()->has('tme'))
  <p><font color=red>セッションタイムアウトしました。再度ログインして下さい。</font></p>
@endif
@if($errors->has('errmsg'))
  <p><font color=red>{{$errors->first('errmsg')}}</font></p>
@endif
<table table-condensed>
  <form method="POST" action="/scvmanager/login" width="400">
    {!!csrf_field()!!}
    {{-- SCVManagerとSCVFlowを同時に開いたときセッションが被るので、リダイレクト先を保存しておく --}}
    <input type="hidden" name="intended" value="{{ session('url.intended', '/scvmanager') }}">
    <tr>
    　　<td>Username</td>
      <td><input type="text" name="username" value="{{ old('username') }}" autofocus></td -->
    </tr>
    <tr>
    　　<td>Password</td>
      <td><input type="password" name="password" id="password"></td>
    <tr>
      <td></td>
    　　<td><button type="submit">ログイン</button></td>
    </tr>
  </form>
</table>

<br>
<br>
@else
<div class="page-header">
  <h3>このサーバはMasterサーバではありません。</h3>
  <h4 style="color:red">SCVManagerによる操作はマスターサーバで行ってください</h4>
</div>
<a href="{{ CH::getMasterUrl() .'/scvmanager' }}">マスターサーバはこちら</a>
@endif
@stop