<!-- scv/resources/views/batch/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>ユーザ一括登録</h3>
</div>

@foreach($errors->all() as $error)
  <p style="color:red">{{ $error }}</p>
@endforeach

<button type="button" onclick="history.back()">戻る</button>

<h4>csvダウンロード</h4>
<button id="download">csvダウンロード</button>

<h4>csvアップロード</h4>
<form id="upload" action="{{URL::to('/scvmanager/batch/upload')}}" method="post" enctype="multipart/form-data">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="file" name="file"><br>
  <input id="csv_submit" type="submit" value="送信">
</form>
@stop
@section('script')
<script type="module" src="{!! asset('js/js.cookie-2.2.1.min.js') !!}"></script>
<script type="text/javascript">
  $('#download').click(function (){
    if(confirm("csvをダウンロードしてもよろしいですか？")){
      location.href = "{{URL::to('/scvmanager/batch/csv')}}";
    }
  });

  $('#upload').submit(function (){
    $('#csv_submit').prop('disabled', true).val('処理中');
    var intervalId = setInterval(function () {
      if (Cookies.get('EXPORTED')) {
        $('#csv_submit').prop('disabled', false).val('送信');
        clearInterval(intervalId);
        Cookies.remove('EXPORTED');
      }
    }, 1000);
  });
</script>
@stop