<!-- scv/resources/views/br_settings/create.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/br_settings.css') !!}">
@endsection

@section('content')
  <div class="page-header">
    <h3>RevoBrowser設定作成<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif
  <button onclick="location.href='{{ URL::to('/scvmanager/br_settings') }}'">戻る</button>

  {{ Form::open(['action' => 'BrSettingController@store']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名 <span style="color: red">*</span></th>
      <td>BR_{{ Form::text('name', null, ['required' => 'required']) }}</td>
    </tr>
    <tr>
      <th class="gray">使用するブラウザ <span style="color: red">*</span></th>
      <td>
        {{-- {{ Form::select('browsers[]', $browsers, 'Firefox', ['multiple' => 'multiple']) }} --}}
        @foreach ($browsers as $browser)
          <label>{{$browser}}:{{ Form::checkbox('browsers[]', $browser, $browser == 'Firefox')}}</label>
        @endforeach
      </td>
    </tr>
    <tr>
      <th class="gray">Chrome設定</th>
      <td>{{ Form::select('chrome_setting_id', $chrome_settings->pluck('name', 'id')->prepend('なし', '0')) }}</td>
    </tr>
    <tr>
      <th class="gray">Edge設定</th>
      <td>{{ Form::select('edge_setting_id', $edge_settings->pluck('name', 'id')->prepend('なし', '0')) }}</td>
    </tr>
    <tr>
      <th class="gray">Proxy設定</th>
      <td>{{ Form::select('proxy_setting_id', $proxy_settings->pluck('name', 'id')->prepend('なし', '0')) }}</td>
    </tr>
    <tr>
      <th class="gray">VPN設定
      </th>
      <td id="vpn_settings_td">
        {{ Form::select('vpn_settings_select', $vpn_settings->pluck('name', 'id')->prepend('選択してください', '0'), 0, ['id' => 'vpn_settings_select']) }}
        <span id="vpn-settings-tooltip"></span>
        <br>
        <ol id="vpn_settings_name" class='list-group'></ol>
      </td>
    </tr>
    <tr>
      <th class="gray">共有フォルダ</th>
      <td>
        <select name="shareprofile_id">
          <option value="0" selected>なし</option>
          @foreach($shareprofiles as $sp)
            <option value="{{$sp->id}}">{{$sp->org_name}}/{{$sp->shname}}</option>
          @endforeach
        </select>
      </td>
    </tr>
  </table>
  {{ Form::submit('作成') }}
  {{ Form::close() }}
  
@stop



@section('script')
  <script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
  <script src="{!! asset('js/tooltips.js') !!}"></script>
  <script src="{!! asset('js/scvmanager/br_settings.js') !!}"></script>
@stop
