<!-- scv/resources/views/br_settings/edit.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/br_settings.css') !!}">
@endsection

@section('content')
  <div class="page-header">
    <h3>RevoBrowser設定変更<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/br_settings') }}'">戻る</button>

  {{ Form::model($br_setting, ['url' => url("/scvmanager/br_settings/$br_setting->id"), 'method' => 'put']) }}
  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名 <span style="color: red">*</span></th>
      <td>BR_{{ Form::text('name', preg_replace('/^BR_/', '', $br_setting->name), ['required' => 'required']) }}</td>
    </tr>
    <tr>
      <th class="gray">使用するブラウザ <span style="color: red">*</span></th>
      <td>
        @foreach ($browsers as $browser)
          <label>{{$browser}}:{{ Form::checkbox('browsers[]', $browser, in_array($browser, $selected_browser))}}</label>
        @endforeach
        </td>
      </tr>
    <tr>
      <th class="gray">Chrome設定</th>
      <td>{{ Form::select('chrome_setting_id', $chrome_settings->pluck('name', 'id')->prepend('なし', '0')), $br_setting->chrome_setting_id }}</td>
    </tr>
    <tr>
      <th class="gray">Edge設定</th>
      <td>{{ Form::select('edge_setting_id', $edge_settings->pluck('name', 'id')->prepend('なし', '0')), $br_setting->edge_setting_id }}</td>
    </tr>
    <tr>
      <th class="gray">Proxy設定</th>
      <td>{{ Form::select('proxy_setting_id', $proxy_settings->pluck('name', 'id')->prepend('なし', '0')), $br_setting->proxy_setting_id }}</td>
    </tr>
    <tr>
      <th class="gray">VPN設定</th>
      <td id="vpn_settings_td">
        {{ Form::select('vpn_settings_select', $vpn_settings->pluck('name', 'id')->prepend('選択してください', '0'), 0, ['id' => 'vpn_settings_select', ]) }}
        <ol id="vpn_settings_name" class='list-group'>
          @foreach ($br_setting->vpnSettings as $vs)
          <li class="list-group-item" data-vs-id="{{$vs->id}}">{{$vs->name}}
            <button type="button" class="close vs-remove"><span>×</span></button>
          </li>
          <input type="hidden" name="vpn_settings[{{$vs->id}}]" value="{{$loop->iteration}}" class="vpn_settings_input">
          @endforeach
        </ol>
      </td>
    </tr>
    <tr>
      <th class="gray">共有フォルダ</th>
      <td>
        <select name="shareprofile_id">
          <option value="0">なし</option>
          @foreach($shareprofiles as $sp)
            <option value="{{$sp->id}}" @if($sp->id == $br_setting->shareprofile_id) selected @endif>{{$sp->org_name}}/{{$sp->shname}}</option>
          @endforeach
        </select>
      </td>
    </tr>
  </table>
  {{ Form::submit('変更') }}
  {{ Form::close() }}
@stop

@section('script')
  <script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
  <script src="{!! asset('js/tooltips.js') !!}"></script>
  <script src="{!! asset('js/scvmanager/br_settings.js') !!}"></script>
@stop
