<!-- scv/resources/views/br_settings/index.blade.php -->
@extends('layout.default')
@section('content')
  <div class="page-header">
    <h3>RevoBrowser設定<span class="revobr-icon"></span></h3>
  </div>

  <p>RevoWorks Browserの設定を管理します。</p>
  @if (Session::has('success'))
    <p class="text-info">{!! Session::get('success') !!}</p>
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/scvgroups') }}'">戻る</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/br_settings/create') }}'">作成</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/chrome_settings') }}'">Chrome設定</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/edge_settings') }}'">Edge設定</button>
  <button onclick="location.href='{{ route('managed_bookmarks.index') }}'">Bookmark設定</button>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered table-striped">
      <tr>
        <th>id</th>
        <th>設定名</th>
        <th>使用するブラウザ</th>
        <th>Proxy設定名</th>
        <th>VPN設定名</th>
      </tr>
      @foreach ($settings as $s)
        <tr>
          <td>{{ $s->id }}</td>
          <td><a href="{{ URL::to("/scvmanager/br_settings/$s->id") }}">{{ $s->name }}</a></td>
          <td>{{ $s->available_browser }}</td>
          <td>
            @if($s->proxySetting)
              <a href="{{ URL::to("/scvmanager/proxy_settings/{$s->proxySetting->id}") }}">{{ $s->proxySetting->name}}</a>
            @endif
          </td>
          <td>
            @foreach ($s->vpnSettings as $vs)
            {{$loop->iteration}}.<a href="{{URL::to("/scvmanager/vpn_settings/$vs->id")}}">{{$vs->name}}</a>
              @if (!$loop->last)
              ,
              @endif
            @endforeach
          </td>
        </tr>
      @endforeach
    </table>
  </div>
@stop

@section('script')
  <script>
  </script>
@stop
