<!-- scv/resources/views/br_settings/show.blade.php -->
@extends('layout.default')
@section('content')

  <div class="page-header">
    <h3>RevoBrowser設定詳細<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  {{ Form::open(['url' => "/scvmanager/br_settings/{$setting->id}", 'method' => 'delete']) }}
  <button type="button" onclick="location.href='{{ URL::to('/scvmanager/br_settings') }}'">戻る</button>
  <button type="button" onclick="location.href='/scvmanager/br_settings/{{ $setting->id }}/edit'">編集</button>
  {{ Form::hidden('id', $setting->id) }}
  {{ Form::submit('削除', ['onclick' => 'return check();']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名</th>
      <td>{{ $setting->name }}</td>
    </tr>
    <tr>
      <th class="gray">使用するブラウザ</th>
      <td>{{ $setting->available_browser }}</td>
    </tr>
    <tr>
      <th class="gray">Chrome設定</th>
      <td>
        @if($setting->chromeSetting)
          <a href="{{URL::to("/scvmanager/chrome_settings/{$setting->chromeSetting->id}")}}">{{ $setting->chromeSetting->name }}</a>
        @else
          なし
        @endif
      </td>
    </tr>
    <tr>
      <th class="gray">Edge設定</th>
      <td>
        @if($setting->edgeSetting)
          <a href="{{URL::to("/scvmanager/edge_settings/{$setting->edgeSetting->id}")}}">{{ $setting->edgeSetting->name }}</a>
        @else
          なし
        @endif
      </td>
    </tr>
    <tr>
      <th class="gray">Proxy設定</th>
      <td>
        @if($setting->proxySetting)
          <a href="{{URL::to("/scvmanager/proxy_settings/{$setting->proxySetting->id}")}}">{{ $setting->proxySetting->name }}</a>
        @else
          なし
        @endif
      </td>
    </tr>
    <tr>
      <th class="gray">VPN設定</th>
      <td>
        @foreach ($setting->vpnSettings as $vs)
          {{$loop->iteration}}.<a href="{{URL::to("/scvmanager/vpn_settings/$vs->id")}}">{{$vs->name}}</a>
          @if (!$loop->last)
          ,
          @endif
        @endforeach
      </td>
    </tr>
    <tr>
      <th class="gray">共有フォルダ</th>
      <td>
        @if($shareprofile)
          <a href="{{URL::to("/scvmanager/share/{$shareprofile->id}")}}">{{ $shareprofile->org_name}}/{{ $shareprofile->shname }}</a>
        @else
          なし
        @endif
      </td>
    </tr>
  </table>
@stop

@section('script')
  <script>
    $(function() {
      $("form").submit(function() {
        if (confirm("{{ $setting->name }}を削除しますか？")) {
          return true;
        } else {
          return false;
        }
      });
    });

  </script>
@stop
