<!-- scv/resources/views/containers/index.blade.php -->
@extends('layout.default')
@section('content')

<?php
 if(!isset($word)){ $word = ""; } ?>

<div class="page-header">
  <h3>動作中のコンテナ</h3>
</div>

@if($errors->has('errmsg'))
  <p><font color=red>{{$errors->first('errmsg')}}</font></p>
@endif

<form style="float:right;" action="{{URL::to('/scvmanager/cluster/search')}}" method="post">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="text" name="word" placeholder="検索ワード" value="{{$word}}">
  <input type="submit" value="検索">
</form>
<form action="{{URL::to('/scvmanager/cluster/containers')}}" method="POST">
  <button id="all" type="button">全選択</button>
  <input type="submit" name="remove" value="削除">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="_method" value="DELETE">
  <table class="table table-condensed table-striped table-bordered">
    <thead>
      <tr>
        <th></th>
        <th>No.</th>
        <th>ホスト名</th>
        <th>コンテナID</th>
        <th>イメージ</th>
        <!-- <th>ステータス</th> -->
        <th>ユーザ名</th>
        <th>コンテナ名</th>
        <th>クライアント</th>
      </tr>
    </thead>
    <tbody>
      @for ($i=0; $i<count($containers); $i++)
        <tr>
          <td><input type="checkbox" name="check[]" value="{{$containers[$i]}}" class="running"></td>
          <td>{{$i+1}}</td>
          <td>{{$containers[$i]->hostname}}</td>
          <td>{{$containers[$i]->containerid}}</td>
          <td>{{$containers[$i]->image}}</td>
          {{--<td>{{$containers[$i]->status}}</td>--}}
          <td>{{$containers[$i]->username}}</td>
          <td>{{$containers[$i]->containername}}</td>
          <td>{{$containers[$i]->clienthost}}</td>
        </tr>
      @endfor
    </tbody>
  </table>
</form>
<div style="clear:both"></div>

<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection
@section('script')
<script type="text/javascript">
  $(document).ready(function(){
    var flg = true;
    $('#all').click( function() {
      $('input[class="running"]').prop('checked', flg);
      if(!flg) flg = true;
      else flg = false;
    });
  });
</script>
@endsection