<!-- scv/resources/views/cluster/index.blade.php -->
@extends('layout.default')
@section('content')
<?php
 exec('cat /var/www/html/scv/.scvconf | grep ^SCV_CLUSTID= | cut -d = -f 2', $clustid); ?>
<div class="page-header">
  <h3>稼働状況<small class="pull-right">{{date('Y/m/d H:i:s')}}</small></h3>
</div>

@if($errors->has('errmsg'))
  <p><font color=red>{{$errors->first('errmsg')}}</font></p>
@endif

<br>
<p>クラスターID:{{$clustid[0]}}</p>
<table class="table table-condensed table-bordered table-hover">
  <thead>
    <tr>
      <th>No.</th>
      <th>ホスト名</th>
      <th>IPアドレス</th>
      <th>ロール</th>
      <th>ステータス</th>
      <th>TPL</th>
      <th>コア</th>
      <th>LDAVG</th>
      <th>PP</th>
      <th>コンテナ({{$container_cnt}})</th>
      <th>更新日</th>
    </tr>
  </thead>
  <tbody>
    @for ($i=0; $i<count($clusters); $i++)
      <tr class="servers" style="cursor:pointer">
        <td class="text-center">{{$i+1}}</td>
        <td>{{$clusters[$i]->hostname}}</td>
        <td>{{$clusters[$i]->ipaddress}}</td>
        <td>{{$clusters[$i]->role}}</td>
        <td>
          <!-- ステータスをメッセージに変換 -->
          <?php $stat = $clusters[$i]->status ?>
          @if($stat == 100)     ACTIVE
          @elseif($stat == 110) ACTIVE(NOLIC)
          @elseif($stat == 101) UPDATING
          @elseif($stat == 200) INACTIVE
          @elseif($stat == 300) DB OLD STAT
          @elseif($stat == 400) ACTSYNCING
          @elseif($stat == 500) OLDSYNCING
          @elseif($stat == 600) INACTIVE OVER 30MIN
          @elseif($stat == 700) CLUSTER ID MISSMATCH
          @elseif($stat == 800) ANOTHER MASTER EXISTS
          @elseif($stat == 900) ANOTHER SLAVE EXISTS
          @endif
        </td>
        <td>
          <?php $tplstat = $clusters[$i]->tpl_syncstate ?>
          @if( mb_strtolower($clusters[$i]->role == 'master') ) MASTER
          @elseif($tplstat == 100) SYNCED
          @elseif($tplstat == 300) OLD
          @else                    UNKNOWN
          @endif
        </td>
        <td class="text-center">{{$clusters[$i]->cpucores}}</td>
        <td class="text-center">{{$clusters[$i]->cpuloadavg}}</td>
        <td class="text-center">{{$clusters[$i]->cpuloadavgpp}}</td>
        <td class="text-center">{{$clusters[$i]->containers}}</td>
        <td>{{$clusters[$i]->updated_at}}</td>
      </tr>
    @endfor
  </tbody>
</table>
<div style="padding-bottom:50px;">
  <button onclick="location.href='{{URL::to('/scvmanager/cluster/containers')}}'">コンテナ一覧</button>
  {{--<button onclick="location.href='{{URL::to('/scvmanager/cluster/reserved')}}'">リザーブドコンテナ一覧</button>--}}
</div>

<h4>サーバ状況</h4>
<h5>Masterサーバシステム情報</h5>
<table class="table table-condensed table-bordered">
  <thead>
    <tr>
    </tr>
    <tr>
      <th>CPU</th>
      <th>メモリ容量</th>
      <th>OS</th>
      <th>CPU利用率</th>
      <th>メモリ利用率</th>
      <th>ディスク利用率</th>
      <th>ロードアベレージ</th>
    </tr>
  </thead>
  <tbody>
        <tr>
        <td>{{$serverdata['cpu']}}</td>
        <td><div class="text-center">{{$serverdata['mem']}}</div></td>
        <td>{{$serverdata['os_version']}}</td>
        <!-- <td><div class="text-center">'.$serverdata['cpuused'].'</div></td> -->
        <td><div id="cpuused" class="text-center"></div></td>
        <td><div class="text-center">{{$serverdata['memused']}}</div></td>
        <td><div class="text-center">{{$serverdata['discused']}}</div></td>
        <td><div class="text-center">{{$serverdata['load_avarage']}}</div></td>
      </tr>
  </tbody>
</table>
<h5>DB情報</h5>
<table class="table table-condensed table-bordered">
  <thead>
    <tr>
      <th></th>
      <th>サイズ</th>
      <th>ユーザ数</th>
      <th>グループ数</th>
      <th>clientlogsレコード</th>
      <th>performancesレコード</th>
      <th>filelogsレコード</th>
    </tr>
  </thead>
  <tbody>
    <tr>
        <th>Master</th>
        <td><div class="text-center">{{$serverdata['dbsize']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_user']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_group']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_logs']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_perf']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_file']}}</div></td>
    </tr>
    <tr>
        <th>Slave</th>
        <td><div class="text-center">{{$slavedata['dbsize']}}</div></td>
        <td><div class="text-center">{{$slavedata['cnt_user']}}</div></td>
        <td><div class="text-center">{{$slavedata['cnt_group']}}</div></td>
        <td><div class="text-center"> - </div></td>
        <td><div class="text-center">{{$slavedata['cnt_perf']}}</div></td>
        <td><div class="text-center"> - </div></td>
    </tr>
  </tbody>
</table>

<!-- モーダル・ダイアログ -->
<div class="modal fade" id="sampleModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">サーバ情報</h4>
      </div>
      <div class="modal-body">
        <table class="table table-striped table-bordered">
          <tr>
            <th>IPアドレス</th>
            <td id="ip"></td>
          </tr>
          <tr>
            <th>ホスト名</th>
            <td id="hostname"></td>
          </tr>
          <tr>
            <th>ロール</th>
            <td id="role"></td>
          </tr>
          <tr>
            <th>CPU</th>
            <td id="cpu"></td>
          </tr>
          <tr>
            <th>CPU使用率</th>
            <td id="cpuused_modal"></td>
          </tr>
          <tr>
            <th>メモリ容量</th>
            <td id="mem"></td>
          </tr>
          <tr>
            <th>メモリ使用率</th>
            <td id="memused"></td>
          </tr>
          <tr>
            <th>ディスク使用率</th>
            <td id="discused"></td>
          </tr>
          <tr>
            <th>ロードアベレージ</th>
            <td id="load_avarage"></td>
          </tr>
          <tr>
            <th>OSバージョン</th>
            <td id="os_version"></td>
          </tr>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">閉じる</button>
      </div>
    </div>
  </div>
</div>
<!-- モーダル・ダイアログ -->

<!--ローディング画面-->
<div class="modal" id="modal-loading" tabindex="-1">
  <div class="modal-dialog modal-sm">
    <div class="modal-content" style="border: 0; box-shadow: none; background: none; padding-top: 50%; position: 'fixed';">
      <div class="modal-body">
        <img src='{{asset("/images/loading.gif")}}' style="height: 200px; width: 200px;">
      </div>
    </div>
  </div>
</div>
<!--ローディング画面ここまで-->
<meta name="csrf-token" content="{{ csrf_token() }}">
@stop

@section('script')
<script type="text/javascript" src="{!! asset('js/scvmanager/cluster.js') !!}"></script>
@stop