<!-- scv/resources/views/containers/index.blade.php -->
@extends('layout.default')
@section('content')

<?php $cnt=1; ?>

<div class="page-header">
  <h3>動作中のコンテナ</h3>
</div>

<form action="{{URL::to('/scvmanager/container/1')}}" method="POST">
  <button class="all" type="button">全選択</button>
  <input type="submit" name="remove" value="削除">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="_method" value="DELETE">
  <br>
  <table class="table table-condensed table-striped table-bordered">
  <thead>
    <tr>
      <td></td>
      <td>No.</td>
      <td>ID</td>
      <td>イメージ</td>
      <td>ステータス</td>
      <td>ポート</td>
      <td>ユーザ名</td>
      <td>コンテナ名</td>
      <td>CPU使用率 / Proc</td>
      <td>CPU使用率 / All</td>
      <td>メモリ使用量</td>
    </tr>
  </thead>
  <tbody>
      @foreach ($result as $line)
        <tr class="running">
        <td><div class="text-center"><input class="running" type="checkbox" name="check[]" value="{{$line['id']}}"></div></td>
        <td>{{$cnt++}}</td>
        <td class="cid"><div class="text-center">{{$line['id']}}</div></td>
        <td><div class="text-center">{{$line['image']}}</div></td>
        <td><div class="text-center">{{$line['status']}}</div></td>
        <td><div class="text-center">{{$line['port']}}</div></td>
        <td><div class="text-center">{{$line['name']}}</div></td>
        <td><div class="text-center">{{$line['container']}}</div></td>
        <td></td>
        <td></td>
        <td></td>
        </tr>
      @endforeach
  </tbody>
  </table>
  <button class="all" type="button">全選択</button>
  <input type="submit" name="remove" value="削除">
</form>

<div class="page-header">
<h3>停止中のコンテナ</h3>
</div>

<form action="{{URL::to('/scvmanager/container/1')}}" method="POST">
  <input type="submit" name="removeall" value="全削除">
  <input type="submit" name="remove"    value="削除">
  <input type="hidden" name="_token"    value="{{csrf_token()}}">
  <input type="hidden" name="_method" value="DELETE">
  <br>
  <table class="table table-condensed table-striped table-bordered">
  <thead>
    <tr>
      <td></td>
      <td>ID</td>
      <td>イメージ</td>
      <td>ステータス</td>
      <td>ユーザ名</td>
      <td>コンテナ名</td>
    </tr>
  </thead>
  <tbody>
      @foreach ($stopped as $line)
        <tr>
        <td><div class="text-center"><input type="checkbox" name="check[]" value="{{$line['name']}}"></div></td>
        <td>{{$line['id']}}</td>
        <td>{{$line['image']}}</td>
        <td>{{$line['status']}}</td>
        <td>{{$line['name']}}</td>
        <td>{{$line['container']}}</td>
        </tr>
      @endforeach
  </tbody>
  </table>
</form>
<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection
@section('script')
<script type="text/javascript">
  $(document).ready(function(){
    var flg = true;
    $('.all').click( function() {
      $('input[class="running"]').prop('checked', flg);
      if(!flg) flg = true;
      else flg = false;
    });

    $.ajaxSetup({
      headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
    });
    $.ajax({
      type: "POST",
      url: "/scvmanager/cpuajax",
      data: {data:"1"},

      /**
      * Ajax通信が成功した場合に呼び出されるメソッド
      */
      success: function(data, dataType)
      {
      //受け取ったjsonオブジェクトをパース
        var getdata = JSON.parse(data);

        //.cidの要素全てに対してCPU使用率をセットする処理
        $('.cid').each(function(){
          for(var i=0; i<getdata.length; i++){
            console.log(getdata);
            //サーバから渡されたコンテナIDの中にHTMLで表示されているコンテナIDが含まれるかチェック
            var re = new RegExp('^'+$(this).text());
            if(getdata[i]['id'].match(re)){
              //コンテナIDが一致した要素にCPU使用率をセット
              $(this).siblings(":last-child").prev().prev().html('<div class="text-center">'+getdata[i]['cpu'] + ' %</div>');
              $(this).siblings(":last-child").prev().html('<div class="text-center">'+getdata[i]['cpupersys'] + ' %</div>');
              var memlen = getdata[i]['mem'].length;
              var mem    = '';
              if(memlen < 5){
                mem = Number(getdata[i]['mem']).toLocaleString() + ' byte';
              }else if(memlen < 8){
                mem = Math.round((Number(getdata[i]['mem']) / 1024)).toLocaleString() + ' KB';
              }else if(memlen < 11){
                mem = Math.round((Number(getdata[i]['mem']) / 1024 / 1024)).toLocaleString() + ' MB';
              }else if(memlen < 14){
                mem = Math.round((Number(getdata[i]['mem']) / 1024 / 1024 / 1024)).toLocaleString() + ' GB';
              }
              // console.log(getdata[i]);
              // console.log(mem);
              // console.log(getdata[i]['mem'].length);
              $(this).siblings(":last-child").html('<div class="text-center">'+mem+'</div>');
            }
          }
        });

      },
      /**
      * Ajax通信が失敗した場合に呼び出されるメソッド
      */
      error: function(XMLHttpRequest, textStatus, errorThrown)
      {
      //通常はここでtextStatusやerrorThrownの値を見て処理を切り分けるか、単純に通信に失敗した際の処理を記述します。
      //this;
      //thisは他のコールバック関数同様にAJAX通信時のオプションを示します。
      //エラーメッセージの表示
        // alert('Error : ' + errorThrown);
      }
    });

  });
</script>
@endsection
