<!-- scv/resources/views/devices/revobr/create.blade.php -->
@extends('layout.default')

@section('head')
    <link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
    <link rel="stylesheet" href="{!! asset('css/scvmanager/update-policy.css') !!}" />
@endsection

@section('content')

<div class="page-header">
  <h3>RevoWorks Browser Updater<span class="revobr-icon"></span></h3>
</div>
@if(isset($return_array))
  @foreach($return_array as $ret)
    {!! $ret !!}
  @endforeach
@endif
@foreach ($errors->all() as $error)
  <p style="color:red">{{ $error }}</p>
@endforeach


<button type="button" onclick="history.back()">戻る</button>
{!! Form::open(['url' => '/scvmanager/devices/revobr/policy', 'method' => 'post']) !!}
<div class="table">
    <table class="table table-condensed table-bordered ">
        <tr>
            <th>ポリシー名 <span style="color:red">*</span></th>
            <td>{{Form::text('name', null, ['required' => 'required'])}}</td>
        </tr>
        <tr>
            <th>マッチタイプ <span style="color:red">*</span></th>
            <td>
                @if(session('init'))
                    {{Form::select('match_type', [ 0 => 'Any', 1 => 'IPv4', 3 => 'ホスト名', 8 => 'グループ'], 0, ['disabled' => 'disabled'])}}
                    {{Form::text('match_value', '', ['disabled' => 'disabled'])}}
                @else
                    {{Form::select('match_type', [1 => 'IPv4', 3 => 'ホスト名', 8 => 'グループ'])}}
                    {{Form::text('match_value', null, ['required' => 'required'])}}
                @endif
            </td>
        </tr>
        <tr>
            <th rowspan="3">スケジュール</th>
            <td>
                {{Form::select('type', ['一度だけ実行', '一定間隔で実行', '週次実行', '月次実行'])}}
            </td>
        </tr>
        <tr id="day_record">
            <td>
                {{Form::text('scheduled_day', date('Y/m/d'), ['id' => 'scheduled_day', 'readonly' => 'readonly'])}}
            </td>
        </tr>
        <tr id="interval_record">
            <td>
                <label>{{Form::number('scheduled_interval', 1, ['id' => 'scheduled_interval', 'min' => 1, 'max' => 365])}} 日毎</label>
            </td>
        </tr>
        <tr id="week_record">
            <td>
                <label>{{Form::radio('scheduled_weekly', 1)}} 日</label>
                <label>{{Form::radio('scheduled_weekly', 2)}} 月</label>
                <label>{{Form::radio('scheduled_weekly', 3)}} 火</label>
                <label>{{Form::radio('scheduled_weekly', 4)}} 水</label>
                <label>{{Form::radio('scheduled_weekly', 5)}} 木</label>
                <label>{{Form::radio('scheduled_weekly', 6)}} 金</label>
                <label>{{Form::radio('scheduled_weekly', 7)}} 土</label>
            </td>
        </tr>
        <tr id="month_record">
            <td>
                <label>{{Form::selectRange('scheduled_monthly', 1, 31)}} 日</label>
            </td>
        </tr>
        <tr>
            <td>
                <label>開始時刻： {{Form::text('scheduled_start_time', '00:00', ['id' => 'scheduled_start_time'])}}</label><br>
                <label>時間枠　： {{Form::number('scheduled_time_period', 0, ['id' => 'scheduled_time_period', 'min' => 0, 'max' => 24])}} 時間</label>
            </td>
        </tr>
        <tr>
            <th>対象アプリケーション <span style="color:red">*</span></th>
            <td>
                <label>{{Form::checkbox('app_all')}} すべて</label>
                <br>
                <label>{{Form::checkbox('target_application[]', '2')}} アップデータ</label>
                <label>{{Form::checkbox('target_application[]', '4')}} クライアント</label>
                <label>{{Form::checkbox('target_application[]', '8')}} Firefox</label>
                <label>{{Form::checkbox('target_application[]', '16')}} Chrome</label>
                <label>{{Form::checkbox('target_application[]', '32')}} Extension</label>
            </td>
        </tr>
        <tr>
            <th>アップデートメニュー非表示化</th>
            <td>{{Form::checkbox('hide_update_menu')}}</td>
        </tr>
        <tr>
            <th>アップデートサーバ <span style="color:red">*</span></th>
            <td>{{Form::text('update_from', null, ['required' => 'required'])}}</td>
        </tr>
        <tr>
            <th>ポリシー更新間隔</th>
            <td>
                <label>{{Form::number('policy_refresh_interval', 0, ['id' => 'policy_refresh_interval', 'min' => 0, 'max' => 240])}} 時間</label>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td>{{Form::submit('登録')}}</td>
        </tr>
    </table>
</div>
{!! Form::close() !!}

@endsection
@section('script')
<script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
<script src="{!! asset('js/scvmanager/update-policy.js') !!}"></script>
@endsection