<!-- scv/resources/views/devices/revobr/index.blade.php -->
@extends('layout.default')
@section('head')
  <link rel="stylesheet" href="{!! asset('css/jquery-ui.min.css') !!}" type="text/css">
  <style>
    #policies {
      cursor:move;
    }
  </style>
@endsection
@section('content')

<div class="page-header">
  <h3>RevoWorks Browser Updater<span class="revobr-icon"></span></h3>
</div>
@if(isset($return_array))
  @foreach($return_array as $ret)
    {!! $ret !!}
  @endforeach
@endif
@foreach ($errors->all() as $error)
  <p style="color:red">{{ $error }}</p>
@endforeach
<button onclick="location.href='{{URL::to('/scvmanager/devices/revobr/policy/create')}}'">作成</button>
<button onclick="location.href='{{URL::to('/scvmanager/devices/revobr/upload')}}'">キットアップロード</button>

<div class="table-responsive">
  <table class="table table-condensed table-bordered table-hover">
    <caption>アップデートポリシー</caption>
    <thead>
      <tr>
        <th class="hidden">ID</th>
        <th class="hidden">order</th>
        <th class="col-md-3">ポリシー名</th>
        <th class="col-md-3">マッチタイプ</th>
        <th class="col-md-3">スケジュール</th>
        <th class="col-md-3">時間</th>
      </tr>
    </thead>
    <tbody id="policies">
    @foreach($policies as $policy)
      <tr>
        <td class="hidden">{{$policy->id}}</td>
        <td class="hidden">{{$policy->order}}</td>
        <td><a href='{{URL::to("/scvmanager/devices/revobr/policy/$policy->id")}}'>{{$policy->name}}</a></td>
        <td>{{$policy->match_type_string}}</td>
        <td>{{$policy->scheduled_string}}</td>
        <td>{{$policy->scheduled_start_time}} から {{$policy->scheduled_time_period}} 時間</td>
      </tr>
    @endforeach
    </tbody>
  </table>
  <table class="table table-condensed table-bordered table-hover">
    <caption>デフォルトポリシー</caption>
    <thead>
      <tr>
        <th class="hidden">ID</th>
        <th class="hidden">order</th>
        <th class="col-md-3">ポリシー名</th>
        <th class="col-md-3">マッチタイプ</th>
        <th class="col-md-3">スケジュール</th>
        <th class="col-md-3">時間</th>
      </tr>
    </thead>
    <tbody>
      @if($default_pol)
        <tr>
          <td><a href='{{URL::to("/scvmanager/devices/revobr/policy/$default_pol->id")}}'>{{$default_pol->name}}</a></td>
          <td>Any</td>
          <td>{{$default_pol->scheduled_string}}</td>
          <td>{{$default_pol->scheduled_start_time}} から {{$default_pol->scheduled_time_period}}</td>
        </tr>
      @endif
    </tbody>

  </table>
</div>
@endsection

<meta name="csrf-token" content="{{ csrf_token() }}">
@section('script')
  <script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
  <script>
  $(function(){
    var url = "{{URL::to('/scvmanager/devices/revobr/policy_sort')}}";
    var fixHelperModified = function(e, tr) {
      var $originals = tr.children();
      var $helper = tr.clone();
      $helper.children().each(function(index){
        $(this).width($originals.eq(index).width());
      });
      return $helper;
    };
    function createData(){
      var data = [];
      $('#policies tr').each(function(index, element){
        var obj = {
          "id": $(element).children().first()[0].innerHTML,
          "index": index
        }
        data.push(obj);
      });
      var records = {
        records: data
      }
      console.log(JSON.stringify(records));
      return JSON.stringify(records);
    }
    function updateRequest(){
      
      $.ajaxSetup({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
          'Content-Type': 'application/json'
        }
      });
      $.ajax({
        url: url,
        type: 'POST',
        dataType: 'json',
        data: createData(),
        success: function(data){
          console.log(data);
        }
      });
      console.log("update request");
    }
    $('#policies').sortable({
      helper: fixHelperModified,
      update: updateRequest
    });
  });
  </script>
@endsection