<!-- scv/resources/views/devices/revobr/show.blade.php -->
@extends('layout.default')
@section('content')

<?php $url = "/scvmanager/devices/revobr/policy/$policy->id"; ?>

<div class="page-header">
  <h3>RevoWorks Browser Updater ポリシー詳細<span class="revobr-icon"></span></h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

{!! Form::open(['url' => "$url", 'method' => 'delete', 'id' => 'delete']) !!}
<button type="button" onclick="history.back()">戻る</button>
<button type="button" onclick="location.href='{{$url.'/edit'}}'">編集</button>
@if($policy->match_type != 0)
  {{ Form::submit('削除', ['id' => 'delete_button']) }}
@endif
<div class="table-responsive">
  <table class="table table-condensed table-bordered">
    <tr>
      <th class="col-md-6">ポリシー名</th>
      <td class="col-md-6">{{ $policy->name }}</td>
    </tr>
    <tr>
      <th>マッチタイプ</th>
      <td>{{$policy->match_type_string}}</td>
    </tr>
    <tr>
      <th>スケジュール</th>
      <td>{{ $policy->scheduled_string }}</td>
    </tr>
    <tr>
      <th>実行時刻</th>
      <td>{{ $policy->scheduled_start_time }} から {{ $policy->scheduled_time_period }} 時間</td>
    </tr>
    <tr>
      <th>アップデートサーバ</th>
      <td>{{ $policy->update_from }}</td>
    </tr>
    <tr>
      <th>対象アプリケーション</th>
      <td>{{ $policy->target_application_string }}</td>
    </tr>
    <tr>
      <th>アップデートメニュー非表示化</th>
      <td>{{ $policy->hide_update_menu_string }}</td>
    </tr>
    <tr>
      <th>ポリシー更新間隔</th>
      <td>{{ $policy->policy_refresh_interval }} 時間</td>
    </tr>
  </table>
</div>
@endsection
@section('script')
<script src="{!! asset('js/scvmanager/update-policy.js') !!}"></script>
<script>

$(function(){
  $('#delete').submit(function(){
    if(confirm("{{ $policy->name }} を削除しますか？")){
      return true;
    }else{
      return false;
    }
  });
});
</script>
@endsection