{{-- scv/resources/views/devices/revobr/upload.blade.php --}}
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>RevoWorks Browser Updater<span class="revobr-icon"></span></h3>
</div>
@if(isset($return_array))
  @foreach($return_array as $ret)
    {{ $ret }}
  @endforeach
@endif
@foreach ($errors->all() as $error)
  <p style="color:red">{{ $error }}</p>
@endforeach

<?php
 $active_tab = Session::get('active_tab'); $updater_active = $active_tab == 'updater' ? 'active' : ''; $client_active = $active_tab == 'client' ? 'active' : ''; $firefox_active = $active_tab == 'firefox' ? 'active' : ''; $chrome_active = $active_tab == 'chrome' ? 'active' : ''; $extension_active = $active_tab == 'extension' ? 'active' : ''; if(!$client_active && !$firefox_active && !$chrome_active && !$extension_active){ $updater_active = 'active'; } ?>

<button onclick="location.href='{{ URL::to('/scvmanager/devices/revobr/policy') }}'">戻る</button>
<br><br>

<ul class="nav nav-tabs">
  <li class="{{$updater_active}}"><a href="#updater" data-toggle="tab">アップデータ</a></li>
  <li class="{{$client_active}}"><a href="#client" data-toggle="tab">クライアント</a></li>
  <li class="{{$firefox_active}}"><a href="#firefox" data-toggle="tab">Firefox</a></li>
  <li class="{{$chrome_active}}"><a href="#chrome" data-toggle="tab">Chrome</a></li>
  <li class="{{$extension_active}}"><a href="#extension" data-toggle="tab">Extension</a></li>
</ul>

<div class="tab-content">
  <div class="tab-pane {{$updater_active}}" id="updater">
    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'post', 'files' => true]) }}
      {{ Form::hidden('active_tab', 'updater') }}
      <table class="table table-striped">
        <caption>アップデータキットアップロード</caption>
        <tr>
          <td class="col-md-3">{{ Form::file('updater', ['required' => 'required']) }}</td>
          <td class="col-md-9">{{ Form::submit('アップロード') }}</td>
        </tr>
      </table>
    {{ Form::close() }}

    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'delete', 'class' => 'version_form', 'id' => 'update_form']) }}
    {{ Form::hidden('active_tab', 'updater') }}
    <table class="table table-condensed table-bordered table-striped">
      <caption>アップデータ一覧</caption>
      <tr>
        <td class="hidden">ID</td>
        <td class="col-md-2">バージョン</td>
        <td class="col-md-6">ファイル名</td>
        <td class="col-md-2">利用する</td>
        <td class="col-md-2"></td>
      </tr>
        @foreach($updaters as $updater)
          <tr>
            <td class="hidden">{{$updater->id}}</td>
            <td>{{$updater->version}}</td>
            <td class="fname_text">{{$updater->file_name}}</td>
            <td>{{Form::radio('updater_radio', $updater->file_name, $updater->specified )}}</td>
            <td>{{Form::submit('削除', ['name' => 'delete', 'class' => 'action', 'formaction' => "/scvmanager/devices/revobr/upload/$updater->id"])}}</td>
          </tr>
        @endforeach
    </table>
    {{Form::submit('変更', ['name' => 'update', 'class' => 'action hidden'])}}
    {{ Form::close() }}
  </div>

  <div class="tab-pane {{$client_active}}" id="client">
    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'post', 'files' => true]) }}
      {{ Form::hidden('active_tab', 'client') }}
      <table class="table table-striped">
        <caption>クライアントキットアップロード</caption>
        <tr>
          <td class="col-md-3">{{ Form::file('client', ['required' => 'required']) }}</td>
          <td class="col-md-9">{{ Form::submit('アップロード') }}</td>
        </tr>
      </table>
    {{ Form::close() }}

    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'delete', 'class' => 'version_form', 'id' => 'client_form']) }}
      {{ Form::hidden('active_tab', 'client') }}
      <table class="table table-condensed table-bordered table-striped">
        <caption>クライアント一覧</caption>
        <tr>
          <td class="hidden">ID</td>
          <td class="col-md-2">バージョン</td>
          <td class="col-md-6">ファイル名</td>
          <td class="col-md-2">利用する</td>
          <td class="col-md-2"></td>
        </tr>
          @foreach($clients as $client)
            <tr>
              <td class="hidden">{{$client->id}}</td>
              <td>{{$client->version}}</td>
              <td class="fname_text">{{$client->file_name}}</td>
              <td>{{Form::radio('client_radio', $client->file_name, $client->specified, ['id' => 'version_radio'] )}}</td>
              <td>{{Form::submit('削除', ['name' => 'delete', 'class' => 'action', 'formaction' => "/scvmanager/devices/revobr/upload/$client->id"])}}</td>
            </tr>
          @endforeach
      </table>
      {{Form::submit('変更', ['name' => 'update', 'class' => 'action hidden'])}}
    {{ Form::close() }}
  </div>

  <div class="tab-pane {{$firefox_active}}" id="firefox">
    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'post', 'files' => true]) }}
      {{ Form::hidden('active_tab', 'firefox') }}
      <table class="table table-striped">
        <caption>Firefoxキットアップロード</caption>
        <tr>
          <td class="col-md-3">{{ Form::file('firefox', ['required' => 'required']) }}</td>
          <td class="col-md-9">{{ Form::submit('アップロード') }}</td>
        </tr>
      </table>
    {{ Form::close() }}

    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'delete', 'class' => 'version_form', 'id' => 'firefox_form']) }}
    {{ Form::hidden('active_tab', 'firefox') }}
    <table class="table table-condensed table-bordered table-striped">
      <caption>Firefox一覧</caption>
      <tr>
        <td class="hidden">ID</td>
        <td class="col-md-2">バージョン</td>
        <td class="col-md-6">ファイル名</td>
        <td class="col-md-2">利用する</td>
        <td class="col-md-2"></td>
      </tr>
        @foreach($firefoxes as $firefox)
          <tr>
            <td class="hidden">{{$firefox->id}}</td>
            <td>{{$firefox->version}}</td>
            <td class="fname_text">{{$firefox->file_name}}</td>
            <td>{{Form::radio('firefox_radio', $firefox->file_name, $firefox->specified )}}</td>
            <td>{{Form::submit('削除', ['name' => 'delete', 'class' => 'action', 'formaction' => "/scvmanager/devices/revobr/upload/$firefox->id"])}}</td>
          </tr>
        @endforeach
    </table>
    {{Form::submit('変更', ['name' => 'chrome', 'class' => 'action hidden'])}}
    {{ Form::close() }}
  </div>
  
  <div class="tab-pane {{$chrome_active}}" id="chrome">
    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'post', 'files' => true]) }}
      {{ Form::hidden('active_tab', 'chrome') }}
      <table class="table table-striped">
        <caption>Chromeキットアップロード</caption>
        <tr>
          <td class="col-md-3">{{ Form::file('chrome', ['required' => 'required']) }}</td>
          <td class="col-md-9">{{ Form::submit('アップロード') }}</td>
        </tr>
      </table>
    {{ Form::close() }}

    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'delete', 'class' => 'version_form', 'id' => 'chrome_form']) }}
    {{ Form::hidden('active_tab', 'chrome') }}
    <table class="table table-condensed table-bordered table-striped">
      <caption>Chrome一覧</caption>
      <tr>
        <td class="hidden">ID</td>
        <td class="col-md-2">バージョン</td>
        <td class="col-md-6">ファイル名</td>
        <td class="col-md-2">利用する</td>
        <td class="col-md-2"></td>
      </tr>
        @foreach($chromes as $chrome)
          <tr>
            <td class="hidden">{{$chrome->id}}</td>
            <td>{{$chrome->version}}</td>
            <td class="fname_text">{{$chrome->file_name}}</td>
            <td>{{Form::radio('chrome_radio', $chrome->file_name, $chrome->specified )}}</td>
            <td>{{Form::submit('削除', ['name' => 'delete', 'class' => 'action', 'formaction' => "/scvmanager/devices/revobr/upload/$chrome->id"])}}</td>
          </tr>
        @endforeach
    </table>
    {{Form::submit('変更', ['name' => 'chrome', 'class' => 'action hidden'])}}
    {{ Form::close() }}
  </div>
  
  <div class="tab-pane {{$extension_active}}" id="extension">
    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'post', 'files' => true]) }}
      {{ Form::hidden('active_tab', 'extension') }}
      <table class="table table-striped">
        <caption>Extensionキットアップロード</caption>
        <tr>
          <td class="col-md-3">{{ Form::file('extension', ['required' => 'required']) }}</td>
          <td class="col-md-9">{{ Form::submit('アップロード') }}</td>
        </tr>
      </table>
    {{ Form::close() }}

    {{ Form::open(['url' => '/scvmanager/devices/revobr/upload', 'method' => 'delete', 'class' => 'version_form', 'id' => 'extension_form']) }}
    {{ Form::hidden('active_tab', 'extension') }}
    <table class="table table-condensed table-bordered table-striped">
      <caption>Extension一覧</caption>
      <tr>
        <td class="hidden">ID</td>
        <td class="col-md-2">バージョン</td>
        <td class="col-md-6">ファイル名</td>
        <td class="col-md-2">利用する</td>
        <td class="col-md-2"></td>
      </tr>
        @foreach($extensions as $extension)
          <tr>
            <td class="hidden">{{$extension->id}}</td>
            <td>{{$extension->version}}</td>
            <td class="fname_text">{{$extension->file_name}}</td>
            <td>{{Form::radio('extension_radio', $extension->file_name, $extension->specified )}}</td>
            <td>{{Form::submit('削除', ['name' => 'delete', 'class' => 'action', 'formaction' => "/scvmanager/devices/revobr/upload/$extension->id"])}}</td>
          </tr>
        @endforeach
    </table>
    {{Form::submit('変更', ['name' => 'extension', 'class' => 'action hidden'])}}
    {{ Form::close() }}
  </div>
</div>
<!--ローディング画面-->
<div class="modal" id="modal-loading" tabindex="-1">
  <div class="modal-dialog modal-sm">
    <div class="modal-content" style="border: 0; box-shadow: none; background: none; padding-top: 50%; position: 'fixed';">
      <div class="modal-body">
        <img src='{{asset("/images/loading.gif")}}' style="height: 200px; width: 200px;"> 
      </div>
    </div>
  </div>
</div>
@stop
@section('script')
  <script>
    function prePutProcess(radio){
      id = radio.parent().siblings(':first').text();
      $('input[name=_method]').val('put');
      radio.parents('form')
        .attr('action', "/scvmanager/devices/revobr/upload/"+id)
        .submit();
    }
    $(function(){
      $(':radio').change(function(e){
        prePutProcess($(this));
      });

      $('input[name=delete]').click(function(e){
        var fname = $(this).parent().siblings('.fname_text').text();
        if(!confirm(fname + 'を削除しますか？')) return false;
        $("<input>", {type: "hidden", name: "file_name", value: fname}).appendTo($(this));
      });

      $('form').submit(function() {
        $("input[type='submit']").prop("disabled", true);
        $('#modal-loading').modal({
          show: true,
          backdrop: 'static'
        });
      });
    });
  </script>
@stop