<!-- scv/resources/views/devices/revodt_list/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>RevoWorks Desktop 端末一覧<span class="revodt-icon"></span></h3>
</div>

<p>指定した端末のシークレットファイルを削除します。<br>
<span style="color: red">シークレットファイルを削除すると、端末のデータは二度と復元できなくなります。</span></p>

@if (Session::has('success'))
  <p class="text-info">{!! Session::get('success') !!}</p>
@endif

@foreach ($errors->all() as $error)
  <p style="color:red">{{ $error }}</p>
@endforeach

{!! Form::open(['url' => '/scvmanager/devices/revodt_list/search', 'method' => 'post']) !!}
{!! Form::text('text', null, ['placeholder' => '検索ワード']) !!}
{!! Form::submit('検索') !!}
{!! Form::close() !!}

<div class="text-center">{!! $revodesktops->render() !!}</div>
{!! Form::open(['url' => '/scvmanager/devices/revodt_list', 'method' => 'post', 'id' => 'test']) !!}
<table class="table table-condensed table-bordered table-striped">
  <caption>端末一覧</caption>
  <tr>
    <th>削除</th>
    <th>PC名</th>
    <th>仮想デスクトップ名</th>
    <th>ユーザ名</th>
    <th>アプリ情報</th>
    <th>ステータス</th>
    <th>コミット数</th>
    <th>最終コミット日時</th>
  </tr>
  @foreach ($revodesktops as $revodesktop)
  <tr class="dev_setting">
    <td style="text-align: center">{{ Form::radio('delete', $revodesktop->id) }}</td>
    <td class="dev_pcname">{{ $revodesktop->pcname }}</td>
    <td>
      @if($revodesktop->dtname)
        <a class="dev_dtname" href="/scvmanager/visionprof/{{ $revodesktop->vp_id }}">{{ $revodesktop->dtname }}</a>
      @else
        {{$revodesktop->dtname}}
      @endif  
    </td>
    <td><a class="dev_username" href="/scvmanager/scvusers/{{ $revodesktop->uid }}">{{ $revodesktop->user }}</a></td>
    <td><a class="show-apps" data-pcname="{{ $revodesktop->pcname }}" data-avalilable-apps="{{ $revodesktop->available_apps_comma }}" data-installed-apps="{{ $revodesktop->installed_apps_comma }}" data-toggle="modal" data-target="#modal-sample">アプリ一覧</a></td>
    <td>{{ $revodesktop->dtstatus }}</td>
    <td>{{ $revodesktop->commited_count }}</td>
    <td>{{ $revodesktop->lastcommited_at }}</td>
  </tr>
  @endforeach
</table>
{!! Form::submit('シークレットファイル削除', ['onclick'=>'return check()']) !!}
{!! Form::close() !!}
<div class="text-center">{!! $revodesktops->render() !!}</div>

{{-- 利用可能なアプリ一覧のモーダルダイアログ --}}
<div class="modal fade" id="modal-sample" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">
          <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title" id="modal-label"></h4>
      </div>
      <div class="modal-body"></div>
      <div class="modal-header">
        <h4 class="modal-title" id="modal-label2"></h4>
      </div>
      <div class="modal-body2"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">閉じる</button>
      </div>
    </div>
  </div>
</div>
@stop

@section('script')
<script>
"use strict";

$('.show-apps').click(function (e) {
  var target = $(e.target);
  var pcname = target.data('pcname');
  var available_apps = target.data('avalilable-apps').split(',');
  var installed_apps = target.data('installed-apps').split(',');
  var title = "'" + pcname + "'で利用可能なアプリ";
  var title2 = "'" + pcname + "' にインストール済みのアプリ";
  var body = to_list_html(available_apps);
  var body2 = to_list_html(installed_apps);
  $('#modal-label').text(title);
  $('#modal-label2').text(title2);
  $('.modal-body').html(body);
  $('.modal-body2').html(body2);
  return true;
});

function to_list_html(values) {
  var body = "<ul>";

  for (var _iterator = values, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
    var _ref;

    if (_isArray) {
      if (_i >= _iterator.length) break;
      _ref = _iterator[_i++];
    } else {
      _i = _iterator.next();
      if (_i.done) break;
      _ref = _i.value;
    }

    var value = _ref;
    body += "<li>" + value + "</li>";
  }

  body += "</ul>";
  return body;
}

function check() {
  if (!$('input[name=delete]:checked').val()) {
    return false;
  }

  var record = $('input[name=delete]:checked').parents('.dev_setting');
  var pcname = record.find('.dev_pcname').text();
  var dtname = record.find('.dev_dtname').text();
  var username = record.find('.dev_username').text();

  if (confirm("以下のシークレットファイルを削除しますか？\nPC名:" + pcname + "\n仮想デスクトップ名:" + dtname + "\nユーザ名:" + username)) {
    return true;
  } else {
    return false;
  }
}
</script>
@stop



