<!-- scv/resources/views/devices/revodt_list/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>RevoWorks Desktop 端末検索結果<span class="revodt-icon"></span></h3>
</div>

<button onclick="location.href='{{URL::to('/scvmanager/devices/revodt_list')}}'">戻る</button>
{!! Form::open(['url' => '/scvmanager/devices/revodt_list', 'method' => 'post', 'id' => 'test']) !!}
<table class="table table-condensed table-bordered table-striped">
  <caption>検索結果</caption>
  <tr>
    <th>削除</th>
    <th>PC名</th>
    <th>仮想デスクトップ名</th>
    <th>ユーザ名</th>
    <th>アプリ情報</th>
    <th>ステータス</th>
    <th>コミット数</th>
    <th>最終コミット日時</th>
  </tr>
  @foreach ($revodesktops as $revodesktop)
  <tr class="dev_setting">
    <td style="text-align: center">{{ Form::radio('delete', $revodesktop->id) }}</td>
    <td class="dev_pcname">{{ $revodesktop->pcname }}</td>
    <td>
      <?php $dtid = @\App\Visionprofile::where('name', $revodesktop->dtname)->first()->id ?>
      <a class="dev_dtname" href="/scvmanager/visionprof/{{ $dtid }}">{{ $revodesktop->dtname }}</a>
    </td>
    <td><a class="dev_username" href="/scvmanager/scvusers/{{ $revodesktop->uid }}">{{ $revodesktop->user }}</a></td>
    <td><a class="show-apps" data-pcname="{{ $revodesktop->pcname }}" data-avalilable-apps="{{ $revodesktop->available_apps_comma }}" data-installed-apps="{{ $revodesktop->installed_apps_comma }}" data-toggle="modal" data-target="#modal-sample">アプリ一覧</a></td>
    <td>{{ $revodesktop->dtstatus }}</td>
    <td>{{ $revodesktop->commited_count }}</td>
    <td>{{ $revodesktop->lastcommited_at }}</td>
  </tr>
  @endforeach
</table>
{!! Form::submit('シークレットファイル削除', ['onclick'=>'return check()']) !!}
{!! Form::close() !!}

{{-- 利用可能なアプリ一覧のモーダルダイアログ --}}
<div class="modal fade" id="modal-sample" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">
          <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title" id="modal-label"></h4>
      </div>
      <div class="modal-body"></div>
      <div class="modal-header">
        <h4 class="modal-title" id="modal-label2"></h4>
      </div>
      <div class="modal-body2"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">閉じる</button>
      </div>
    </div>
  </div>
</div>
@stop

@section('script')
  <script>
    $('.show-apps').click((e) => {
      let target = $(e.target);
      let pcname = target.data('pcname');
      let available_apps = target.data('avalilable-apps').split(',');
      let installed_apps = target.data('installed-apps').split(',');
      let title  = `'${pcname}' で利用可能なアプリ`;
      let title2 = `'${pcname}' にインストール済みのアプリ`;
      let body   = to_list_html(available_apps);
      let body2  = to_list_html(installed_apps);
      $('#modal-label').text(title);
      $('#modal-label2').text(title2);
      $('.modal-body').html(body);
      $('.modal-body2').html(body2);
      return true;
    });

    function to_list_html(values) {
      let body   = `<ul>`;
      for (let value of values)
        body += `<li>${value}</li>`;
      body += `</ul>`;
      return body;
    }

    function check() {
      if (!$('input[name=delete]:checked').val()) {
        return false;
      }
      let record = $('input[name=delete]:checked').parents('.dev_setting');
      let pcname = record.find('.dev_pcname').text();
      let dtname = record.find('.dev_dtname').text();
      let username = record.find('.dev_username').text();
      if(confirm(`以下のシークレットファイルを削除しますか？\nPC名:${pcname}\n仮想デスクトップ名:${dtname}\nユーザ名:${username}`)) {
        return true;
      }else{
        return false;
      }
  }
  </script>
@stop