<!-- scv/resources/views/edge_settings/create.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/edge_settings.css') !!}">
@endsection

@section('content')
  <div class="page-header">
    <h3>Edge設定作成<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif
  <button onclick="location.href='{{ URL::to('/scvmanager/edge_settings') }}'">戻る</button>

  {{ Form::open(['action' => 'EdgeSettingController@store']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名 <span style="color: red">*</span></th>
      <td>EDGE_{{ Form::text('name', null, ['required' => 'required']) }}</td>
    </tr>
    <tr>
      <th class="gray">ホームページ</th>
      <td>{{ Form::text('homepage') }}</td>
    </tr>
    <tr>
      <th class="gray">スタートページ</th>
      <td>{{ Form::text('startup_page') }}</td>
    </tr>
    <tr>
      <th class="gray">新しいタブページ</th>
      <td>{{ Form::text('new_tab_page') }}</td>
    </tr>
    <tr>
      <th class="gray">プロファイル保存</th>
      {{ Form::hidden('save_profile', 0) }}
      <td>{{ Form::checkbox('save_profile', 1, true, ['id' => 'save_profile']) }}</td>
    </tr>
    <tr>
      <th class="gray">履歴保存</th>
      {{ Form::hidden('save_history', 0) }}
      <td>{{ Form::checkbox('save_history', 1, true, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">パスワード保存</th>
      {{ Form::hidden('save_password', 0) }}
      <td>{{ Form::checkbox('save_password', 1, true, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">Cookie保存</th>
      {{ Form::hidden('save_cookie', 0) }}
      <td>{{ Form::checkbox('save_cookie', 1, true, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">ブックマーク保存</th>
      {{ Form::hidden('save_bookmark', 0) }}
      <td>{{ Form::checkbox('save_bookmark', 1, true, ['class' => 'save_checkbox']) }}</td>
    </tr>
    <tr>
      <th class="gray">設定ページ非表示</th>
      {{ Form::hidden('hide_internal_pages', 0) }}
      <td>{{ Form::checkbox('hide_internal_pages') }}</td>
    </tr>
    <tr>
      <th class="gray">X-Forwarded-For有効化</th>
      {{ Form::hidden('enable_xff', 0) }}
      <td>{{ Form::checkbox('enable_xff') }}</td>
    </tr>
    <tr>
      <th class="gray">Proxy-Authorization有効化</th>
      {{ Form::hidden('enable_pauth', 0) }}
      <td>
        {{ Form::checkbox('enable_pauth') }}
        <span class="glyphicon glyphicon-question-sign text-info" id="pauth_pop" data-toggle="popover" title="Proxy-Authorization"></span>
        <br><label>ユーザ名、パスワードを指定する：{{Form::checkbox('pauth_account', null, null, ['id' => 'pauth_account'])}}</label>
        <span class="glyphicon glyphicon-question-sign text-info" id="pauth_account_pop" data-toggle="popover" title="ユーザ名、パスワードを指定する"></span>
        <div id="pauth_account_inputs">
          ユーザ名　：{{Form::text('pauth_user', null, ['maxlength' => 255])}}
          <br>
          パスワード：{{Form::text('pauth_pass', null, ['id' => 'pauth_pass', 'maxlength' => 96])}} <button id="show_password">表示</button>
        </div>
      </td>
    </tr>
    <tr>
      <th class="gray">Bookmarkトップフォルダ名</th>
      <td>{{ Form::text('bookmark_toplevel', null, [ 'placeholder' => '管理対象のお気に入り']) }}</td>
    </tr>
    <tr>
      <th class="gray">Bookmark設定</th>
      <td>
        <div id="bookmark"></div>
        {{ Form::button('削除', [ 'id' => 'bookmark-del' ]) }}
        {{ Form::hidden('bookmarks') }}
      </td>
    </tr>
  </table>
  {{ Form::submit('作成') }}
  {{ Form::close() }}
  
@stop

@section('script')
  <script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
  <script src="{!! asset('js/tooltips.js') !!}"></script>
  <script src="{!! asset('js/scvmanager/edge_settings.js') !!}"></script>
  <script src="{!! asset('js/multiple-selectboxes.js') !!}"></script>
  <script>
    let msb = new MultipleSelectBoxes({
      location:              $('#bookmark'),
      removeButton:          $('#bookmark-del'),
      bindForm:              $('input[name=bookmarks]'),
      bindDelimitor:         ',',
      itemTexts:             {!! $bookmarksSelectBoxData['itemTexts'] !!},
      itemValues:            {!! $bookmarksSelectBoxData['itemValues'] !!},
      initialSelectedItems:  {!! $bookmarksSelectBoxData['initialSelectedItems'] !!},
      minShowingSelects:     1,
      maxShowingSelects:     {!! $bookmarksSelectBoxData['maxShowingSelects'] !!},
      allowDuplicate:        false,
      selectClassName:       'bookmark-selects',
      msgSelectsMaxExceeded: 'これ以上は選択できません',
      msgDuplicatedSelect:   '項目の重複はできません',
      errorAlert:            false
    });
  </script>
@stop
