<!-- scv/resources/views/edge_settings/index.blade.php -->
@extends('layout.default')
@section('content')
  <div class="page-header">
    <h3>Edge設定<span class="revobr-icon"></span></h3>
  </div>

  <p>RevoBrowserで使用するEdgeの設定を管理します。</p>
  @if (Session::has('success'))
    <p class="text-info">{!! Session::get('success') !!}</p>
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/br_settings') }}'">戻る</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/edge_settings/create') }}'">作成</button>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered table-striped">
      <tr>
        <th>id</th>
        <th>設定名</th>
        <th>ホームページ</th>
      </tr>
      @foreach ($settings as $s)
        <tr>
          <td>{{ $s->id }}</td>
          <td><a href="{{ URL::to("/scvmanager/edge_settings/$s->id") }}">{{ $s->name }}</a></td>
          <td>{{ $s->homepage }}</td>
        </tr>
      @endforeach
    </table>
  </div>
@stop

@section('script')
  <script>
  </script>
@stop
