<!-- scv/resources/views/edge_settings/show.blade.php -->
@extends('layout.default')
@section('content')

  <div class="page-header">
    <h3>Edge設定詳細<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  {{ Form::open(['url' => "/scvmanager/edge_settings/{$setting->id}", 'method' => 'delete']) }}
  <button type="button" onclick="location.href='{{ URL::to('/scvmanager/edge_settings') }}'">戻る</button>
  <button type="button" onclick="location.href='/scvmanager/edge_settings/{{ $setting->id }}/edit'">編集</button>
  {{ Form::hidden('id', $setting->id) }}
  {{ Form::submit('削除', ['onclick' => 'return check();']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名</th>
      <td>{{ $setting->name }}</td>
    </tr>
    <tr>
      <th class="gray">ホームページ</th>
      <td>{{ $setting->homepage}}</td>
    </tr>
    <tr>
      <th class="gray">スタートページ</th>
      <td>{{ $setting->startup_page}}</td>
    </tr>
    <tr>
      <th class="gray">新しいタブページ</th>
      <td>{{ $setting->new_tab_page}}</td>
    </tr>
    <tr>
      <th class="gray">プロファイル保存</th>
      <td>{{ $setting->save_profile ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">履歴保存</th>
      <td>{{ $setting->save_history ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">パスワード保存</th>
      <td>{{ $setting->save_password ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">Cookie保存</th>
      <td>{{ $setting->save_cookie ? '保存する' : '保存しない' }}</td>
    </tr>
    <tr>
      <th class="gray">ブックマーク保存</th>
      <td>{{ $setting->save_bookmark ? '保存する' : '保存しない'}}</td>
    </tr>
    <tr>
      <th class="gray">設定ページ</th>
      <td>{{ $setting->hide_internal_pages ? '表示しない' : '表示する' }}</td>
    </tr>
    <tr>
      <th class="gray">X-Forwarded-For有効化</th>
      <td>{{ $setting->enable_xff ? '有効' : '無効'}}</td>
    </tr>
    <tr>
      <th class="gray">Proxy-Authorization有効化</th>
      <td>{{ $setting->enable_pauth ? '有効' : '無効'}}</td>
    </tr>
    <tr>
      <th class="gray">Bookmarkトップフォルダ名</th>
      <td>{{ $setting->bookmark_toplevel}}</td>
    </tr>
    <tr>
      <th class="gray">Bookmark設定</th>
      <td>
        @foreach ($setting->bookmarkNames as $bookmark)
          {{ $bookmark }}<br>
        @endforeach
      </td>
    </tr>
  </table>
@stop

@section('script')
  <script>
    $(function() {
      $("form").submit(function() {
        if (confirm("{{ $setting->name }}を削除しますか？")) {
          return true;
        } else {
          return false;
        }
      });
    });

  </script>
@stop
