<!-- scv/resources/views/edit_user_passwd/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>{{$scvuser->name}}のパスワード変更</h3>
</div>

<p>通常のユーザパスワードの変更を行います。</p>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<button type="button" onclick="location.href='/scvmanager/scvusers/{{$scvuser->id}}'">戻る</button>
<form action="/scvmanager/edit_user_passwd" method="post" id="form">

  <table class="table table-condensed table-bordered">
    @if (App\Libs\ConfHelper::usingPassword() || $scvuser->name == 'scvtemplate')
    <tr>
      <th align="left" width="150" class="gray"><label for="pwd1">パスワード</label></th>
      <td><input type="password" size="20" id="pwd1" name="pwd1" placeholder="パスワード"></td>
    </tr>
    <tr>
      <th align="left" width="150" class="gray"><label for="pwd2">確認用パスワード</label></th>
      <td><input type="password" size="20" id="pwd2" name="pwd2" placeholder="確認用パスワード"></td>
    </tr>
    <tr>
      <td></td>
      <td>
        <input class="submit" type="button" value="変更">
        @if ($gauth)
          <input id="gauth" type="button" value="Google認証の初期化" style="margin-left: 10px">
        @endif
      </td>
    </tr>
    @endif
  </table>

  @if (App\Libs\ConfHelper::usingPassword() || $scvuser->name == 'scvtemplate')
    <div class="page-header">
      <h3>{{$scvuser->name}}の仮パスワード発行</h3>
    </div>

    <p>一定期間有効な仮パスワードを発行します。仮パスワードが有効の間はパスワードポリシーの制限を受けなくなります。</p>

    <table class="table table-condensed table-bordered">
      <tr>
        <th align="left" width="150" class="gray"><label for="tmppwd1">仮パスワード</label></th>
        <td><input type="password" size="20" id="tmppwd1" name="tmppwd1" placeholder="仮パスワード" autofocus></td>
      </tr>
      <tr>
        <th align="left" width="150" class="gray"><label for="tmppwd2">確認用仮パスワード</label></th>
        <td><input type="password" size="20" id="tmppwd2" name="tmppwd2" placeholder="確認用仮パスワード"></td>
      </tr>
      <tr>
        <th align="left" width="150" class="gray"><label for="tmppwd_term">有効日数</label></th>
        <td>{{ Form::number('tmppwd_term', 7, ['min' => 1, 'max' => 99999, 'style' => 'width: 50px; text-align: right; margin-right: 5px;']) }}</td>
      </tr>
      <tr>
        <td></td>
        <td>
          <input class="submit" type="button" value="発行">
        </td>
      </tr>
    </table>
  @endif

  <input type="hidden" name="id" value="{{$scvuser->id}}">
  <input type="hidden" name="name" value="{{$scvuser->name}}">
  <input type="hidden" name="action" value="">
  {{\Session::flash('name',$scvuser->name)}}
  {{\Session::flash('id',$scvuser->id)}}
  <input type="hidden" name="_token" value="{{{ csrf_token() }}}" />
</form>
@stop

@section('script')
<script>
  var form   = $('#form');
  var action = $('input[name=action]');
  $('.submit').click(function() {
    action.val(this.value);
    form.submit();
  });
  $('#gauth').click(function() {
    action.val(this.value);
    if (confirm('このユーザのGoogle認証情報を初期化してもよろしいですか？'))
      form.submit();
  });
</script>
@stop