@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>災害時モード設定</h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button onclick="location.href='{{URL::to('/scvmanager/emergency_mode')}}'">戻る</button>

{{ Form::open(['url' => '/scvmanager/emergency_mode/store', 'method' => 'post'])}}
<div class="table-responsive">
  <table class="table table-condensed table-bordered pwd-policy-wrap">
    <tbody>
      <tr>
        <th>災害時モード</th>
        <td>{{ Form::checkbox('status', 1, $current_status)}}</td>
      </tr>
      <tr>
        <th>残り使用可能回数</th>
        <td>{{$available_count}}</td>
      </tr>
      @if($current_status)
        <tr>
          <th>利用開始日</th>
          <td>{{$activated_date}}</td>
        </tr>
        <tr>
          <th>有効期限</th>
          <td>{{$expiration_date}}</td>
        </tr>
      @endif
    </tbody>
  </table>
</div>
{{ Form::submit('更新')}}
{{ Form::close() }}

@stop
@section('script')
<script src="{!! asset('js/scvmanager/emode.js') !!}"></script>
@stop
