@extends('layout.default')
@section('content')
@section('head')
<link rel="stylesheet" href="{{ asset('/css/scvmanager/emergency-mode.css') }}">
@endsection

<div class="page-header">
  <h3>災害時モード管理</h3>
</div>

@if (Session::has('success'))
  <p class="text-info">{!! Session::get('success') !!}</p>
@endif

@if ($errors->any())
  <p style="color:red">
    @foreach ($errors->all() as $error)
      {{ $error }}<br>
    @endforeach
  </p>
@endif


<button onclick="location.href='{{URL::to('/scvmanager/scvconf')}}'">戻る</button>
<button onclick="location.href='{{URL::to('/scvmanager/emergency_mode/create')}}'">編集</button>

<div class="table-responsive">
  <table class="table table-condensed table-bordered pwd-policy-wrap">
    <tbody>
      <tr>
        <th>災害時モード</th>
        <td>{{$current_status}}</td>
      </tr>
      <tr>
        <th>残り使用可能回数</th>
        <td>{{$available_count}}</td>
      </tr>
      @if($current_status == "有効")
        <tr>
          <th>利用開始日</th>
          <td>{{$activated_date}}</td>
        </tr>
        <tr>
          <th>有効期限</th>
          <td>{{$expiration_date}}</td>
        </tr>
      @endif
    </tbody>
  </table>
</div>

<div>
  <h4>
    過去のモード使用履歴
  </h4>
  <p class="">{{$all_log->links()}}</p>
  <table class="table table-bordered emergency-mode-log-table">
    <tbody>
      <tr>
        <th>災害時モード有効化日時</th>
        <th>災害時モード無効化日時</th>
      </tr>
      @foreach ($all_log as $log)
      <tr>
        <td>{{$log->created_at}}</td>
        <td>{{$log->updated_at->year === -1 ? '---- -- -- --:--:--' : $log->updated_at }}</td>
      </tr>
      @endforeach
    </tbody>
  </table>
<div>

@stop