<!-- scv/resources/views/firefoxprof/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
<h3>{{$firefoxprof->name}}の証明書<span class="scvx-icon"></span><span class="revobr-icon"></span></h3>
</div>
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<?php
 ?>
@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
<button type="button" onclick='location.href="{{URL::to("/scvmanager/firefoxprof/$firefoxprof->id")}}"'>戻る</button>

<br>

<h3>アップロード</h3>
<p>
  ファイル名は 半角英数、半角スペース - = _ ( ) . が利用可能です。<br>
  上記以外の文字が含まれる場合はファイル名を変更してからアップロードしてください。
</p>
<form action="{{URL::to('/scvmanager/firefoxprof/cert/upload')}}" method="post" enctype="multipart/form-data">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="id" value="{{$firefoxprof->id}}">
  <table class="table">
    <tr>
      <td>証明書：</td>
      <td><input type="file" name="file" style="display:inline-block" required></td>
    </tr>
    <tr>
      <td>パスワード：</td>
      <td><input type="password" name="password"></td>
    </tr>
    <tr>
      <td></td>
      <td><input type="submit" value="アップロード"></td>
    </tr>
  </table>
</form>

<br>

<h3>証明書一覧</h3>
<form action="{{URL::to('/scvmanager/firefoxprof/cert/delete')}}" method="post">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="prof_name" value="{{$firefoxprof->name}}">
  <input type="hidden" name="organization_id" value="{{$firefoxprof->organization_id}}">
  <table class="table table-condensed table-bordered table-striped">
    <tr>
      <th>ファイル名</th>
      <th>パスワード</th>
      <td></td>
    </tr>
    @foreach ($files as $file)
      <?php
 $a = explode(",", $file); if($a[2]) $p = "有り" ; else $p = "無し"; ?>
      <tr>
        <td>{{$a[1]}}</td>
        <td>{{$p}}</td>
        <td><button type="submit" name="fn" value="{{$a[1]}}">削除</button></td>
      </tr>
    @endforeach
  </table>
</form>
@endsection
@section('script')
  <script type="text/javascript" src="{!! asset('js/scvmanager/firefoxprof.js') !!}"></script>
@endsection
