<!-- scv/resources/views/firefoxprof/create.blade.php -->
@extends('layout.default')
@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/bookmark.css') !!}">
@endsection
@section('content')
<div class="page-header">
  <h3>Firefox設定作成<span class="scvx-icon"></span><span class="revobr-icon"></span></h3>
</div>
<?php
 if(\Session::has('init')){ $pref_msg = "checked"; $config_msg = "checked"; $accounts_msg = "checked"; $addons_msg = "checked"; $support_msg = "checked"; $profiles_msg = "checked"; $all_msg = "checked"; $bookmarks = null; }else{ $pref_msg = Input::old('about_preferences')=="about_preferences" ? "checked" : ""; $config_msg = Input::old('about_config')=="about_config" ? "checked" : ""; $accounts_msg = Input::old('about_accounts')=="about_accounts" ? "checked" : ""; $addons_msg = Input::old('about_addons')=="about_addons" ? "checked" : ""; $support_msg = Input::old('about_support')=="about_support" ? "checked" : ""; $profiles_msg = Input::old('about_profiles')=="about_profiles" ? "checked" : ""; $all_msg = Input::old('about_all')=="about_all" ? "checked" : ""; $bookmarks = Input::old('bookmarks'); } ?>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<button onclick="location.href='{{URL::to('/scvmanager/firefoxprof')}}'">戻る</button>
{{Form::open(['url' => url('/scvmanager/firefoxprof'), 'method' => 'post'])}}
  <div class="table-responsive">
    <table class="table table-condensed table-bordered">
      <tr>
        <th>Firefox設定名</th>
        <td>PROF_<input type="text" name="name" value="{{Input::old('name')}}"></td>
      </tr>
      <tr>
        <th>組織</th>
        <td>
            @if (\Auth::user()->organization_id === 1)
            <select name="organization_id">
                @foreach ($organizations as $org)
                    <option value={{$org->id}}>{{$org->name}}</option>
                @endforeach
            </select>
            @else
                <input type="hidden" name="organization_id" value={{$organizations->id}}>
                {{$organizations->name}}
            @endif
          </select>
        </td>
      </tr>
    </table>
  </div>

  <div>
    <h5>Firefox設定</h5>
  </div>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered">
      <thead>
        <td class="icon-td"></td>
        <th>項目</th>
        <th>パラメータ</th>
      </thead>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>JavaScript無効</th>
          <td><input type="checkbox" name="disable_js" value="disable_js" @if(Input::old('disable_js')=="disable_js") checked @endif></td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>ホームページ変更</th>
          <td><input type="text" name="homepage" value="{{Input::old('homepage')}}" maxlength="255"></td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Firefox起動時に開くページ</th>
          <td>
            <select name="startup_page">
              {{-- valueはuser.jsの値に合わせてある --}}
              <option value="1" @if(Input::old('startup_page')=='1') selected @endif>ホームページ</option>
              <option value="0" @if(Input::old('startup_page')=='0') selected @endif>空白のページ</option>
              <option value="3" @if(Input::old('startup_page')=='3') selected @endif>前回終了時のタブ</option>
            </select>
            <span class="glyphicon glyphicon-question-sign text-info" id="start_page_pop" data-toggle="popover" title="前回終了時のタブ"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>
            ファイル保存フォルダ
          </th>
          <td>
            <select name="file_path">
              <option value="0" @if(Input::old('file_path')=='0') selected @endif>統一しない</option>
              <option value="1" @if(Input::old('file_path')=='1') selected @endif>ホームに統一する</option>
              <option value="2" @if(Input::old('file_path')=='2') selected @endif>ダウンロードフォルダに統一する</option>
            </select>
            <span class="glyphicon glyphicon-question-sign text-info" id="file_pop" data-toggle="popover" title="ファイル保存フォルダ"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>
            ダウンロードフォルダ名
          </th>
          <td>
            <input type="text" name="downloaddir" value="{{Input::old('downloaddir')}}">
            <span class="glyphicon glyphicon-question-sign text-info" id="downloaddir_pop" data-toggle="popover" title="ダウンロードフォルダ名"></span>
          </td>
        </tr>
        <tr>
          <td class="proxy_header"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th class="proxy_header">プロキシ</th>
          <td>
            <select name="proxy_type">
              <option name="proxy0" value="0" @if(Input::old('proxy')=="0") selected @endif>プロキシを使用しない</option>
              {{--<option name="proxy4" value="4" @if(Input::old('proxy')=="4") selected @endif>このネットワークのプロキシ設定を自動検出する</option>--}}
              {{--<option name="proxy5" value="5" @if(Input::old('proxy')=="5") selected @endif>システムのプロキシ設定を利用する</option>--}}
              <option name="proxy1" value="1" @if(Input::old('proxy')=="1") selected @endif>手動でプロキシを設定する</option>
              <option name="proxy2" value="2" @if(Input::old('proxy')=="2") selected @endif>自動プロキシ設定スクリプト URL</option>
            </select>
          </td>
          <!-- td><div class="text-center"><input type="checkbox" name="proxy_lock" value="proxy_lock" @if(Input::old('proxy_lock')=="proxy_lock") checked @endif></div></td -->
        </tr>
        <tr class="manual">
          <td>HTTPプロキシホスト : <input type="text" name="http_proxy_host" value="{{Input::old('http_proxy_host')}}"></td>
          <!-- td></td -->
        </tr>
        <tr class="manual">
          <td>HTTPプロキシポート : <input type="number" name="http_proxy_port" value="{{Input::old('http_proxy_port')}}" min="0" step="1"></td>
          <!-- td></td -->
        </tr>
        <tr class="manual">
          <td>
            <label>HTTP,SSLでこのプロキシを使用する<input type="checkbox" name="same_proxy" value="same_proxy" @if(Input::old('same_proxy')=="same_proxy") checked @endif></label>
          </td>
        </tr>
        <tr class="manual">
          <td>SSLプロキシホスト : <input type="text" name="ssl_proxy_host" value="{{Input::old('ssl_proxy_host')}}"></td>
          <!-- td></td -->
        </tr>
        <tr class="manual">
          <td>SSLプロキシポート : <input type="number" name="ssl_proxy_port" value="{{Input::old('ssl_proxy_port')}}" min="0" step="1"></td>
          <!-- td></td -->
        </tr>
        <tr class="manual no_proxy">
          <td>
            プロキシ無しで接続 : <input type="text" name="no_proxy_host" value="{{Input::old('no_proxy_host','localhost,127.0.0.1')}}">
            <span class="glyphicon glyphicon-question-sign text-info" id="no_proxy_pop" data-toggle="popover" title="プロキシ無しで接続"></span>
          </td>
        </tr>
        <tr class="proxy_url">
          <td>URL : <input type="text" name="proxy_url" value="{{Input::old('proxy_url')}}"></td>
          <!-- td></td -->
        </tr>
        <tr class="proxy_auth">
          <td>
            <label>パスワードを保存してある場合は認証を確認しない
            <input type="checkbox" name="auth_flag" value="auth_flag" @if(Input::old('auth_flag')=="auth_flag") checked @endif></label>
          </td>
        </tr>
        <tr>
          <td><span class="revobr-icon"></span></td>
          <th>Windowsの証明書をインポートする</th>
          <td>
            {{Form::checkbox('import_enterprise_roots')}}
            <span class="glyphicon glyphicon-question-sign text-info" id="import_enterprise_roots_pop" data-toggle="popover" title="Windowsの証明書をインポートする"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>
            最大タブ数
          </th>
          <td>
            <input type="number" name="max_tab" value="5" min="0" step="1" max="255">
            <span class="glyphicon glyphicon-question-sign text-info" id="tab_pop" data-toggle="popover" title="最大タブ数"></span>
          </td>
          <!-- td></td -->
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>X-Forwarded-For</th>
          <td>
            <label><input type="radio" name="xff_flag" value="empty" @if(Input::old('xff_flag')=='empty') checked @elseif(Input::old('xff_flag') === null) checked @endif>使用しない</label>&nbsp;
            <label><input type="radio" name="xff_flag" value="ip" @if(Input::old('xff_flag')=='ip') checked @endif>IPアドレス</label>&nbsp;
            <label><input type="radio" name="xff_flag" value="user" @if(Input::old('xff_flag')=='user') checked @endif>ユーザ名</label>&nbsp;
            <span class="glyphicon glyphicon-question-sign text-info" id="xff_pop" data-toggle="popover" title="X-Forwarded-For"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Proxy-Authorization</th>
          <td>
            <input type="checkbox" name="pauth"  @if(Input::old('pauth')) checked @endif>
            <span class="glyphicon glyphicon-question-sign text-info" id="pauth_pop" data-toggle="popover" title="Proxy-Authorization"></span>
            <br><label>ユーザ名、パスワードを指定する：{{Form::checkbox('pauth_account', null, null, ['id' => 'pauth_account'])}}</label>
            <span class="glyphicon glyphicon-question-sign text-info" id="pauth_account_pop" data-toggle="popover" title="ユーザ名、パスワードを指定する"></span>
            <div id="pauth_account_inputs">
              ユーザ名　：{{Form::text('pauth_user', null, ['maxlength' => 255])}}
              <br>
              パスワード：{{Form::text('pauth_pass', null, ['id' => 'pauth_pass', 'maxlength' => 96])}} <button id="show_password">表示</button>
            </div>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>コンテンツプロセス数の制限</th>
          <td>
          <input type="number" name="contents_process" min="0" max="7" @if(Input::old('contents_process')) value="{{Input::old('contents_process')}}" @endif)>
            <span class="glyphicon glyphicon-question-sign text-info" id="contents_process_pop" data-toggle="popover" title="コンテンツプロセス数"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>履歴を保存する<span style="color:red;">※</span></th>
          <td>
            <input type="checkbox" name="save_history" value="save_history" @if(Input::old('save_history')=="save_history") checked @endif>
            <span id="hma-input">{{Form::number('history_max_age', 30, ['min' => 1, 'max' => 180])}} 日</span>
            <span class="glyphicon glyphicon-question-sign text-info" id="save_history_pop" data-toggle="popover" title="履歴を保存する"></span>
          </td>
          <!-- td><div class="text-center"><input type="checkbox" name="history_lock" value="history_lock" @if(Input::old('history_lock')=="history_lock") checked @endif></div></td -->
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>パスワードを保存する<span style="color:red;">※</span></th>
          <td><input type="checkbox" name="save_password" value="save_password" @if(Input::old('save_password')=="save_password") checked @endif></td>
          <!-- td><div class="text-center"><input type="checkbox" name="password_lock" value="password_lock" @if(Input::old('password_lock')=="password_lock") checked @endif></div></td -->
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>
            Cookieを保存する<span style="color:red;">※</span>
          </th>
          <td>
            <input type="checkbox" name="save_cookie" value="save_cookie" @if(Input::old('save_cookie')=="save_cookie") checked @endif>
            <span class="glyphicon glyphicon-question-sign text-info" id="cookie_pop" data-toggle="popover" title="Cookie保存"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>
            Pocketを無効化する
          </th>
          <td>
            {{Form::checkbox('disable_pocket')}}
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>オートコンプリートを無効化する</th>
          <td>
            {{Form::checkbox('disable_formfill')}}
            <span class="glyphicon glyphicon-question-sign text-info" id="formfill_pop" data-toggle="popover" title="オートコンプリート無効"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>Chromeで開くメニュー(試験導入)</th>
          <td>
            <input type="checkbox" name="open_chrome" value="open_chrome" @if(Input::old('open_chrome')=="open_chrome") checked @endif>
            <span class="glyphicon glyphicon-question-sign text-info" id="open_chrome_pop" data-toggle="popover" title="chromeで開く"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Captive Portal</th>
          <td>
            {{Form::checkbox('captive_portal', null, true)}}
            <span class="glyphicon glyphicon-question-sign text-info" id="captive_portal_pop" data-toggle="popover" title="Captive Portal"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>ポップアップ許可サイト</th>
          <td>
            {{Form::textarea('allowed_popups', null, ['style' => 'max-width:900px;'])}}
            <span class="glyphicon glyphicon-question-sign text-info" id="allowed_popups_pop" data-toggle="popover" title="ポップアップ許可サイト"></span>
          </td>
        </tr>
    </table>
    <span style="color:red;">※グループ設定でFirefox保存にチェックを入れる必要があります</span>
    <div>
      <h5>Firefox UI設定</h5>
    </div>
    <table class="table table-condensed table-bordered">
      <thead>
        <td class="icon-td"></td>
        <th>項目</th>
        <th>非表示</th>
      </thead>
      <tbody id="about">
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>すべて禁止 (about:home, about:newtab 以外のabout:～禁止)</td>
          <td><div class="text-center"><input type="checkbox" id="all" name="about_all" value="about_all" {{$all_msg}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>オプション設定の禁止 (about:preferences禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_preferences" value="about_preferences" {{$pref_msg}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>詳細設定の禁止 (about:config禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_config" value="about_config" {{$config_msg}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>Syncログインの禁止 (about:accounts禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_accounts" value="about_accounts" {{$accounts_msg}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>アドオン設定の禁止 (about:addons禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_addons" value="about_addons" {{$addons_msg}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>トラブルシューティング情報の禁止 (about:support禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_support" value="about_support" {{$support_msg}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>プロファイル設定の禁止 (about:profiles禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_profiles" value="about_profiles" {{$profiles_msg}}></div></td>
        </tr>
      </tbody>
    </table>
    <div>
      <h5>
        Bookmark設定
        <span class="glyphicon glyphicon-question-sign text-info" id="bookmark_setting_pop" data-toggle="popover" title="Bookmark設定<span class='scvx-icon'></span><span class='revobr-icon'></span>"></span>
        <a data-toggle="modal" data-target="#bookmark-modal" data-backdrop="static" data-clickbutton="new">
          <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
        </a>
      </h5>
    </div>
    <table id="bookmarks-table" class="table table-condensed table-bordered">
      <input type="hidden" name="bookmarks">
      <tr>
        <th>No.</th>
        <th>ブックマーク名</th>
        <th>URL</th>
        <th>場所</th>
        <th>フォルダ名</th>
        <th></th>
        <th></th>
      </tr>
    </table>
  </div>
  <br>
  <input type="submit" value="登録">
{{Form::close()}}

@include('managed_bookmarks.modal')

@endsection
@section('script')
<script>
  var bookmarks = JSON.parse(@json($bookmarks));
  bookmarks = bookmarks ? bookmarks : [];
</script>
<script type="text/javascript" src="{!! asset('js/scvmanager/firefoxprof.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/scvmanager/bookmark.js') !!}"></script>
@endsection
