<!-- scv/resources/views/firefoxprof/create.blade.php -->
<?php
 $id = $firefoxprof->id; $name = $firefoxprof->name; $max_tab = $firefoxprof->max_tab; $disable_js = $firefoxprof->disable_js == "1" ? "checked" : ""; $homepage = $firefoxprof->homepage; $startup_page = $firefoxprof->startup_page; $downloaddir = strpos($firefoxprof->downloaddir,":") ? explode(":", $firefoxprof->downloaddir)[1] : $firefoxprof->downloaddir; $file_path = $firefoxprof->file_path; $proxy_type = $firefoxprof->proxy_type; $http_proxy_host = $firefoxprof->http_proxy_host; $http_proxy_port = $firefoxprof->http_proxy_port; $ssl_proxy_host = $firefoxprof->ssl_proxy_host; $ssl_proxy_port = $firefoxprof->ssl_proxy_port; $no_proxy_host = $firefoxprof->no_proxy_host; $same_proxy = $firefoxprof->same_proxy == "1" ? "checked" : ""; $proxy_url = $firefoxprof->proxy_url; $contents_process = $firefoxprof->contents_process; $save_password = $firefoxprof->save_password == "1" ? "checked" : ""; $save_cookie = $firefoxprof->save_cookie ? "checked" : ""; $open_chrome = $firefoxprof->enable_open_chrome ? "checked" : ""; $disable_config = $firefoxprof->disable_config; $disable_accounts = $firefoxprof->disable_accounts; $disable_addons = $firefoxprof->disable_addons; $disable_home = $firefoxprof->disable_home; $disable_preferences= $firefoxprof->disable_preferences; $disable_support = $firefoxprof->disable_support; $disable_profiles = $firefoxprof->disable_profiles; $disable_all = $firefoxprof->disable_all; $pauth = $firefoxprof->pauth_flag == "1" ? "checked" : ""; $xff_flag = $firefoxprof->xff_flag; $bookmarks = $firefoxprof->bookmarks ?: null; $xff_empty = ""; $xff_ip = ""; $xff_user = ""; if($xff_flag == 0) $xff_empty = "checked"; elseif($xff_flag == 1) $xff_ip = "checked"; elseif($xff_flag == 2) $xff_user = "checked"; $auth_flag = $firefoxprof->proxy_auth == "1" ? "checked" : ""; $disable_config = $disable_config ? "checked" : ""; $disable_accounts = $disable_accounts ? "checked" : ""; $disable_addons = $disable_addons ? "checked" : ""; $disable_home = $disable_home ? "checked" : ""; $disable_preferences= $disable_preferences ? "checked" : ""; $disable_support = $disable_support ? "checked" : ""; $disable_profiles = $disable_profiles ? "checked" : ""; $disable_all = $disable_all ? "checked" : ""; $url = '/scvmanager/firefoxprof/'.$id; ?>
@extends('layout.default')
@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/bookmark.css') !!}">
@endsection
@section('content')
<div class="page-header">
	<h3><span class="scvx-icon"></span><span class="revobr-icon"></span>Firefox設定変更</h3>
</div>
@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<button onclick="location.href='{{$url}}'">戻る</button>
{{Form::model($firefoxprof, ['url' => $url, 'method' => 'put'])}}
  <input type="hidden" name="id" value="{{$id}}">
  <div class="table-responsive">
    <table class="table table-condensed table-bordered">
      <thead>
        <th class="icon-td"></th>
        <th>項目</th>
        <th>パラメータ</th>
        <!-- th>ロック</th -->
      </thead>
        <tr>
          <td></td>
          <th>Firefox設定名</th>
          <td>PROF_<input type="text" name="name" value="{{preg_replace('/^PROF_/','',$name)}}"></td>
        </tr>
        <tr>
          <td></td>
          <th>組織名</th>
            <td>
            @if (\Auth::user()->organization_id === 1)
            <select name="organization_id">
                @foreach ($organizations as $org)
                  @if ($firefoxprof->organization_id === $org->id)
                    <option selected value={{$org->id}}>{{$org->name}}</option>
                  @else
                    <option value={{$org->id}}>{{$org->name}}</option>
                  @endif
                @endforeach
            </select>
            @else
                <input type="hidden" name="organization_id" value={{$organizations->id}}>
                {{$organizations->name}}
            @endif
          </td>               
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>JavaScript無効</th>
          <td><input type="checkbox" name="disable_js" {{$disable_js}}></td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>ホームページ変更</th>
          <td><input type="text" name="homepage" value="{{$homepage}}" maxlength="255"></td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Firefox起動時に開くページ</th>
          <td>
            <select name="startup_page">
              {{-- valueはuser.jsの値に合わせてある --}}
              <option value="1" @if($startup_page =='1') selected @endif>ホームページ</option>
              <option value="0" @if($startup_page =='0') selected @endif>空白のページ</option>
              <option value="3" @if($startup_page =='3') selected @endif>前回終了時のタブ</option>
            </select>
            <span class="glyphicon glyphicon-question-sign text-info" id="start_page_pop" data-toggle="popover" title="前回終了時のタブ"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>ファイル保存フォルダ</th>
          <td>
            <select name="file_path">
              <option value="0" @if($file_path =='0') selected @endif>統一しない</option>
              <option value="1" @if($file_path=='1') selected @endif>ホームに統一する</option>
              <option value="2" @if($file_path=='2') selected @endif>ダウンロードフォルダに統一する</option>
            </select>
            <span class="glyphicon glyphicon-question-sign text-info" id="file_pop" data-toggle="popover" title="ファイル保存フォルダ"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>ダウンロードフォルダ名</th>
          <td>
            <input type="text" name="downloaddir" value="{{$downloaddir}}">
            <span class="glyphicon glyphicon-question-sign text-info" id="downloaddir_pop" data-toggle="popover" title="ダウンロードフォルダ名"></span>
          </td>
        </tr>
        <tr>
          <td class="proxy_header"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th class="proxy_header">プロキシ</th>
          <td>
            <select name="proxy_type">
              <option name="proxy0" value="0" @if($proxy_type=="0") selected @endif>プロキシを使用しない</option>
              {{--<option name="proxy4" value="4" @if($proxy_type=="4") selected @endif>このネットワークのプロキシ設定を自動検出する</option>--}}
              {{--<option name="proxy5" value="5" @if($proxy_type=="5") selected @endif>システムのプロキシ設定を利用する</option>--}}
              <option name="proxy1" value="1" @if($proxy_type=="1") selected @endif>手動でプロキシを設定する</option>
              <option name="proxy2" value="2" @if($proxy_type=="2") selected @endif>自動プロキシ設定スクリプト URL</option>
            </select>
          </td>
        </tr>
        <tr class="manual">
          <td>HTTPプロキシホスト : <input type="text" name="http_proxy_host" value="{{$http_proxy_host}}"></td>
        </tr>
        <tr class="manual">
          <td>HTTPプロキシポート : <input type="number" name="http_proxy_port" value="{{$http_proxy_port}}" min="0" step="1"></td>
        </tr>
        <tr class="manual">
          <td>
            <label>HTTP,SSLでこのプロキシを使用する<input type="checkbox" name="same_proxy" value="same_proxy" {{$same_proxy}}></label>
          </td>
        </tr>
        <tr class="manual">
          <td>SSLプロキシホスト : <input type="text" name="ssl_proxy_host" value="{{$ssl_proxy_host}}"></td>
        </tr>
        <tr class="manual">
          <td>SSLプロキシポート : <input type="number" name="ssl_proxy_port" value="{{$ssl_proxy_port}}" min="0" step="1"></td>
        </tr>
        <tr class="manual">
          <td>
            プロキシ無しで接続 : <input type="text" name="no_proxy_host" value="{{$no_proxy_host}}">
            <span class="glyphicon glyphicon-question-sign text-info" id="no_proxy_pop" data-toggle="popover" title="プロキシ無しで接続"></span>
          </td>
        </tr>
        <tr class="proxy_url">
          <td>URL : <input type="text" name="proxy_url" class="proxy_url" value="{{$proxy_url}}"></td>
        </tr>
        <tr class="proxy_auth">
          <td>
            <label>パスワードを保存してある場合は認証を確認しない
            <input type="checkbox" name="auth_flag" {{$auth_flag}}></label>
          </td>
        </tr>
        <tr>
          <td><span class="revobr-icon"></span></td>
          <th>Windowsの証明書をインポートする</th>
          <td>
            {{Form::checkbox('import_enterprise_roots')}}
            <span class="glyphicon glyphicon-question-sign text-info" id="import_enterprise_roots_pop" data-toggle="popover" title="Windowsの証明書をインポートする"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>最大タブ数</th>
          <td>
            <input type="number" name="max_tab" min="0" step="1" max="255" value="{{$max_tab}}">
            <span class="glyphicon glyphicon-question-sign text-info" id="tab_pop" data-toggle="popover" title="最大タブ数"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>X-Forwarded-For</th>
          <td>
            <label><input type="radio" name="xff_flag" value="empty" {{$xff_empty}}>使用しない</label>&nbsp;
            <label><input type="radio" name="xff_flag" value="ip" {{$xff_ip}}>IPアドレス</label>&nbsp;
            <label><input type="radio" name="xff_flag" value="user" {{$xff_user}}>ユーザ名</label>&nbsp;
            <span class="glyphicon glyphicon-question-sign text-info" id="xff_pop" data-toggle="popover" title="X-Forwarded-For"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Proxy-Authorization</th>
          <td>
            <input type="checkbox" name="pauth" {{$pauth}}>
            <span class="glyphicon glyphicon-question-sign text-info" id="pauth_pop" data-toggle="popover" title="Proxy-Authorization"></span>
            <br><label>ユーザ名、パスワードを指定する：{{Form::checkbox('pauth_account', null, null, ['id' => 'pauth_account'])}}</label>
            <span class="glyphicon glyphicon-question-sign text-info" id="pauth_account_pop" data-toggle="popover" title="ユーザ名、パスワードを指定する"></span>
            <div id="pauth_account_inputs">
              ユーザ名　：{{Form::text('pauth_user', null, ['maxlength' => 255])}}
              <br>
              パスワード：{{Form::text('pauth_pass', null, ['id' => 'pauth_pass', 'maxlength' => 96])}}
              <button id="show_password">表示</button>
            </div>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>コンテンツプロセス数の制限</th>
          <td>
            <input type="number" name="contents_process" min="0" max="7" value="{{$contents_process}}">
            <span class="glyphicon glyphicon-question-sign text-info" id="contents_process_pop" data-toggle="popover" title="コンテンツプロセス数"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>履歴を保存する<span style="color:red;">※</span></th>
          <td>
            {{Form::checkbox('save_history')}}
            <span id="hma-input">{{Form::number('history_max_age', null, ['min' => 1, 'max' => 180])}} 日</span>
            <span class="glyphicon glyphicon-question-sign text-info" id="save_history_pop" data-toggle="popover" title="履歴を保存する"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>パスワードを保存する<span style="color:red;">※</span></th>
          <td><input type="checkbox" name="save_password" {{$save_password}}></td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Cookieを保存する<span style="color:red;">※</span></th>
          <td>
            <input type="checkbox" name="save_cookie" {{$save_cookie}}>
            <span class="glyphicon glyphicon-question-sign text-info" id="cookie_pop" data-toggle="popover" title="Cookie保存"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>
            Pocketを無効化する
          </th>
          <td>
            {{Form::checkbox('disable_pocket')}}
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>オートコンプリートを無効化する</th>
          <td>
            {{Form::checkbox('disable_formfill')}}
            <span class="glyphicon glyphicon-question-sign text-info" id="formfill_pop" data-toggle="popover" title="オートコンプリート無効"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>Chromeで開くメニュー(試験導入)</th>
          <td>
            <input type="checkbox" name="open_chrome" {{$open_chrome}}>
            <span class="glyphicon glyphicon-question-sign text-info" id="open_chrome_pop" data-toggle="popover" title="chromeで開く"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th>Captive Portal</th>
          <td>
            {{Form::checkbox('captive_portal')}}
            <span class="glyphicon glyphicon-question-sign text-info" id="captive_portal_pop" data-toggle="popover" title="Captive Portal"></span>
          </td>
        </tr>
        <tr>
          <td><span class="scvx-icon"></span></td>
          <th>ポップアップ許可サイト</th>
          <td>
            {{Form::textarea('allowed_popups', null, ['style' => 'max-width:900px;'])}}
            <span class="glyphicon glyphicon-question-sign text-info" id="allowed_popups_pop" data-toggle="popover" title="ポップアップ許可サイト"></span>
          </td>
        </tr>
    </table>
    <span style="color:red;">※グループ設定でFirefox保存にチェックを入れる必要があります</span>
  <div>
    <h5>Firefox UI設定</h5>
  </div>
    <table class="table table-condensed table-bordered">
      <thead>
        <td class="icon-td"></td>
        <th>項目</th>
        <th></th>
      </thead>
      <tbody id="about">
        <tr>
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>すべて禁止 (about:home, about:newtab 以外のabout:～禁止)</td>
          <td><div class="text-center"><input type="checkbox" id="all" name="about_all" value="about_all" {{$disable_all}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>オプション設定の禁止 (about:preferences禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_preferences" {{$disable_preferences}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>詳細設定の禁止 (about:config禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_config" {{$disable_config}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>Syncログインの禁止 (about:accounts禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_accounts" {{$disable_accounts}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>アドオン設定の禁止 (about:addons禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_addons" {{$disable_addons}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>トラブルシューティング情報の禁止 (about:support禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_support" {{$disable_support}}></div></td>
        </tr>
        <tr class="some_about">
          <td><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <td>プロファイル設定の禁止 (about:profiles禁止)</td>
          <td><div class="text-center"><input type="checkbox" name="about_profiles" {{$disable_profiles}}></div></td>
        </tr>
      </tbody>
    </table>
    <div>
      <h5>
        Bookmark設定
        <span class="glyphicon glyphicon-question-sign text-info" id="bookmark_setting_pop" data-toggle="popover" title="Bookmark設定<span class='scvx-icon'></span><span class='revobr-icon'></span>"></span>
        <a data-toggle="modal" data-target="#bookmark-modal" data-backdrop="static" data-clickbutton="new">
          <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
        </a>
      </h5>
    </div>
    <table id="bookmarks-table" class="table table-condensed table-bordered">
      <input type="hidden" name="bookmarks">
      <tr>
        <th>No.</th>
        <th>ブックマーク名</th>
        <th>URL</th>
        <th>場所</th>
        <th>フォルダ名</th>
        <th style="width:3%"></th>
        <th style="width:3%"></th>
      </tr>
    </table>
  </div>
  <br>
  <input type="submit" value="更新">
{{Form::close()}}

@include('managed_bookmarks.modal')

@endsection
@section('script')
<script>
  var bookmarks = JSON.parse(@json($bookmarks));
  bookmarks = bookmarks ? bookmarks : [];
</script>
<script type="text/javascript" src="{!! asset('js/scvmanager/firefoxprof.js') !!}"></script>
<script type="text/javascript" src="{!! asset('js/scvmanager/bookmark.js') !!}"></script>
@endsection
