<!-- scv/resources/views/firefoxprof/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>Firefox設定<span class="scvx-icon"></span><span class="revobr-icon"></span></h3>
</div>
@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif
<?php
 require_once(app_path().'/Libs/setIcon.php'); $id = $firefoxprof->id; $name = $firefoxprof->name; $max_tab = $firefoxprof->max_tab ?: seticon(false); $disable_js = seticon($firefoxprof->disable_js); $homepage = $firefoxprof->homepage; $startup_page = $firefoxprof->startup_page; $file_path = $firefoxprof->file_path; $downloaddir = strpos($firefoxprof->downloaddir,":") ? explode(":", $firefoxprof->downloaddir)[1] : $firefoxprof->downloaddir; $proxy_type = $firefoxprof->proxy_type; $http_proxy_host = $firefoxprof->http_proxy_host; $http_proxy_port = $firefoxprof->http_proxy_port; $ssl_proxy_host = $firefoxprof->ssl_proxy_host; $ssl_proxy_port = $firefoxprof->ssl_proxy_port; $no_proxy_host = $firefoxprof->no_proxy_host; $proxy_url = $firefoxprof->proxy_url; $import_enterprise_roots = seticon($firefoxprof->import_enterprise_roots); $contents_process = $firefoxprof->contents_process; $save_history = $firefoxprof->save_history ? $firefoxprof->history_max_age." 日" : '<span class="glyphicon glyphicon-ban-circle text-danger"></span>'; $save_password = seticon($firefoxprof->save_password); $save_cookie = seticon($firefoxprof->save_cookie); $open_chrome = seticon($firefoxprof->enable_open_chrome); $captive_portal = seticon($firefoxprof->captive_portal); $disable_config = seticon($firefoxprof->disable_config); $disable_accounts = seticon($firefoxprof->disable_accounts); $disable_addons = seticon($firefoxprof->disable_addons); $disable_home = seticon($firefoxprof->disable_home); $disable_preferences= seticon($firefoxprof->disable_preferences); $disable_support = seticon($firefoxprof->disable_support); $disable_profiles = seticon($firefoxprof->disable_profiles); $disable_all = seticon($firefoxprof->disable_all); $xff_flag = $firefoxprof->xff_flag; $pauth = seticon($firefoxprof->pauth_flag); $pocket = seticon($firefoxprof->disable_pocket); $formfill = seticon($firefoxprof->disable_formfill); $bookmarks = $firefoxprof->bookmarks ? json_decode($firefoxprof->bookmarks): []; if($startup_page == 0){ $startup_page_txt = "空白のページ"; }elseif($startup_page == 1){ $startup_page_txt = "ホームページ"; }elseif($startup_page == 3){ $startup_page_txt = "前回終了時のタブ"; } $file_path_msg = ""; if($file_path == "0") $file_path_msg = "統一しない"; elseif($file_path == "1" ) $file_path_msg = "ホームに統一する"; elseif($file_path == "2" ) $file_path_msg = "ダウンロードフォルダに統一する"; if($downloaddir == "scvhome") $downloaddir = "ホーム"; $xff_stat = ""; if($xff_flag == 0) $xff_stat = "使用しない"; elseif($xff_flag == 1) $xff_stat = "IPアドレス"; elseif($xff_flag == 2) $xff_stat = "ユーザ名"; $auth_flag = seticon($firefoxprof->proxy_auth); switch ($proxy_type) { case '0': $proxy_type = "使用しない"; break; case '1': $proxy_type = "手動"; break; case '2': $proxy_type = "スクリプト"; break; case '4': $proxy_type = "自動検出"; break; case '5': $proxy_type = "システムの設定"; break; } ?>
@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
@endif

<?php
 $delurl = "/scvmanager/firefoxprof/".$id; $editurl= "/scvmanager/firefoxprof/".$id."/edit"; ?>
<form action="{{$delurl}}" method="post" id="delete">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input type="hidden" name="_method" value="DELETE">
  <input type="hidden" name="id" value="{{$id}}">
  <button type="button" onclick="location.href='/scvmanager/firefoxprof'">戻る</button>
  <button type="button" onclick="location.href='{{$editurl}}'">{{$name}}を編集</button>
  <button type="button" onclick="location.href='/scvmanager/firefoxprof/cert/show/{{$id}}'">証明書管理</button>
  <input type="submit" name="remove" value="削除">
  <div class="table-responsive">
    <br>
    <table class="table table-condensed table-bordered">
      <tr>
        <th align="left" width="150" class="gray">Firefox設定名</th>
        <td id="name">{{$name}}</td>
        <th align="left" width="150" class="gray">組織名</th>
        <td>{{$organization_name}}</td>
      </tr>
      <tr>
        <th align="left" width="150" class="gray">作成日</th>
        <td>{{$firefoxprof->created_at}}</td>
        <th align="left" width="150" class="gray">更新日</th>
        <td>{{$firefoxprof->updated_at}}</td>
      </tr>
    </table>
    <br>
    <table class="table table-condensed table-bordered">
      <tbody>
        <tr>
          <td class="gray icon-td"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">JavaScript無効</th>
          <td>{!!$disable_js!!}</td>
          <td class="gray icon-td"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray col-md-2">scvtemplate</th>
          <td class="col-md-3" id="name">@if($template_exists)有り @else 無し @endif</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">ホームページ</th>
          <td>{{$homepage}}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">Firefox起動時</th>
          <td>{{$startup_page_txt}}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray">ファイル保存フォルダ</th>
          <td>{{$file_path_msg}}</td>
          <td class="gray"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray">ダウンロードフォルダ</th>
          <td>{{$downloaddir}}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">プロキシタイプ</th>
          <td colspan="4">{{$proxy_type}}</td>
        </tr>
        @if($proxy_type=='手動')
        <tr>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">HTTPプロキシホスト</th>
          <td>{{$http_proxy_host}}</td>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">HTTPプロキシポート</th>
          <td>{{$http_proxy_port}}</td>
        </tr>
        <tr>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">SSLプロキシホスト</th>
          <td>{{$ssl_proxy_host}}</td>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">SSLプロキシポート</th>
          <td>{{$ssl_proxy_port}}</td>
        </tr>
        <tr>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">プロキシ無しで接続</th>
          <td colspan="4">{{$no_proxy_host}}</td>
        </tr>
        @endif
        @if($proxy_type=='スクリプト')
        <tr>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">プロキシスクリプト</th>
          <td>{{$proxy_url}}</td>
          <th align="left" width="150" class="gray"></th>
          <td></td>
        </tr>
        @endif
        @if($proxy_type!='使用しない')
        <tr>
          <td class="gray"></td>
          <th align="left" width="150" class="gray">パスワードを保存してある場合は認証を確認しない</th>
          <td colspan="4">{!!$auth_flag!!}</td>
        </tr>
        @endif
        <tr>
          <td class="gray"><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">Windowsの証明書をインポートする</th>
          <td>{!!$import_enterprise_roots!!}</td>
          <td class="gray"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray">最大タブ数</th>
          <td>{!!$max_tab!!}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray">コンテンツプロセス</th>
          <td>@if($contents_process == 0) 自動 @else {{$contents_process}} @endif </td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">X-Forwarded-For</th>
          <td>{{$xff_stat}}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">Proxy-Authorization</th>
          <td>{!!$pauth!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">履歴の保存</th>
          <td>{!!$save_history!!}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">パスワードの保存</th>
          <td>{!!$save_password!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">Cookieの保存</th>
          <td>{!!$save_cookie!!}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray">Chromeで開く</th>
          <td>{!!$open_chrome!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">Captive Portal</th>
          <td>{!!$captive_portal!!}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span></td>
          <th align="left" width="150" class="gray">ポップアップ許可サイト</th>
          <td>
            @if($firefoxprof->allowed_popups != "") 設定済み @else 未設定 @endif
          </td>
          <td></td>
          <th></th>
          <td></td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">Pocket無効</th>
          <td>{!!$pocket!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">オートコンプリート無効</th>
          <td>{!!$formfill!!}</td>
        </tr>
        @if($firefoxprof->disable_all)
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:～全て禁止</th>
          <td>{!!$disable_all!!}</td>
          <td class="gray"></td>
          <th align="left" width="150" class="gray"></th>
          <td></td>
        </tr>
        @else
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:preferences禁止</th>
          <td>{!!$disable_preferences!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:accounts禁止</th>
          <td>{!!$disable_accounts!!}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:config禁止</th>
          <td>{!!$disable_config!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:addons禁止</th>
          <td>{!!$disable_addons!!}</td>
        </tr>
        <tr>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:support禁止</th>
          <td>{!!$disable_support!!}</td>
          <td class="gray"><span class="scvx-icon"></span><span class="revobr-icon"></span></td>
          <th align="left" width="150" class="gray">about:profiles禁止</th>
          <td>{!!$disable_profiles!!}</td>
        </tr>
        @endif
      </tbody>
    </table>
    @if($bookmarks)
    <br>
    <table class="table table-condensed table-bordered">
      <tbody>
        <tr>
          <th colspan="4" class="gray">ブックマーク<span class="scvx-icon"></span><span class="revobr-icon"></span></th>
        </tr>
        <tr>
          <th>ブックマーク名</th>
          <th>URL</th>
          <th>場所</th>
          <th>フォルダ名</th>
        </tr>
        @foreach ($bookmarks as $b)
          <tr>
            <td>{{$b->Title}}</td>
            <td>{{$b->URL}}</td>
            <td>@if($b->Placement == 'menu') メニュー @else ツールバー @endif</td>
            <td>{{$b->Folder}}</td>
          </tr>
        @endforeach
      </tbody>
    </table>
    @endif
  </div>
</form>
@endsection
@section('script')
<script type="text/javascript" src="{!! asset('js/scvmanager/firefoxprof.js') !!}"></script>
@endsection
