<!-- scv/resources/views/home/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>サーバ状況<small class="pull-right">{{date('Y/m/d H:i:s')}}</small></h3>
</div>

@if($errors->has('errmsg'))
  <p><font color=red>{{$errors->first('errmsg')}}</font></p>
@endif

<h5>ホスト情報</h5>
<table class="table table-condensed table-bordered">
  <thead>
    <tr>
      <th class="col-sm-4">ホスト名</th>
      <th class="col-sm-4">IPアドレス</th>
      <th class="col-sm-4">コンテナ数</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>{{$serverdata['hostname']}}</td>
      <td>{{$serverdata['ip_address']}}</td>
      <td>{{$serverdata['number_of_containers']}}</td>
    </tr>
  </tbody>
</table>

<div style="margin-top:20px;padding-bottom:30px;">
  @if (\App\Libs\UserHelper::isAdmin())
    <button onclick="location.href='{{URL::to('/scvmanager/cluster/containers')}}'">コンテナ一覧</button>
    {{--<button onclick="location.href='{{URL::to('/scvmanager/container/reserved')}}'">リザーブドコンテナ一覧</button>--}}
  @endif
</div>

<h5>システム情報</h5>
<table class="table table-condensed table-bordered">
  <thead>
    <tr>
    </tr>
    <tr>
      <th>CPU</th>
      <th>メモリ容量</th>
      <th>OS</th>
      <th>CPU利用率</th>
      <th>メモリ利用率</th>
      <th>ディスク利用率</th>
      <th>ロードアベレージ</th>
    </tr>
  </thead>
  <tbody>
      <tr>
        <td>{{$serverdata['cpu']}}</td>
        <td><div class="text-center">{{$serverdata['mem']}}</div></td>
        <td>{{$serverdata['os_version']}}</td>
        {{--<td><div class="text-center">{{$serverdata['cpuused']}}</div></td>--}}
        <td><div id="cpuused" class="text-center"></div></td>
        <td><div class="text-center">{{$serverdata['memused']}}</div></td>
        <td><div class="text-center">{{$serverdata['discused']}}</div></td>
        <td><div class="text-center">{{$serverdata['load_avarage']}}</div></td>
      </tr>
  </tbody>
</table>

<br>

<h5>DB情報</h5>
<table class="table table-condensed table-bordered">
  <thead>
    <tr>
      <th>サイズ</th>
      <th>ユーザ数</th>
      <th>グループ数</th>
      <th>clientlogsレコード</th>
      <th>performancesレコード</th>
      <th>filelogsレコード</th>
    </tr>
  </thead>
  <tbody>
    <tr>
        <td><div class="text-center">{{$serverdata['dbsize']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_user']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_group']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_logs']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_perf']}}</div></td>
        <td><div class="text-center">{{$serverdata['cnt_file']}}</div></td>
    </tr>
  </tbody>
</table>

<!-- <div class="row">
  <div class="col-md-6">
    <h4>アラート</h4>
    <div class="alert alert-danger" role="alert">
      <strong>Alert</strong> : 重要メッセージ
    </div>
    <div class="alert alert-warning" role="alert">
      <strong>Warning</strong> : 警告メッセージ
    </div>
    <div class="alert alert-info" role="alert">
      <strong>info</strong> : アラート無し
    </div>
  </div>
  <div class="col-md-6">
    <h4>クラスタ状況</h4>
  </div>
</div> -->
@stop

@section('script')
<script type="text/javascript">
	$(document).ready(function(){
		$.ajax({
			type: "GET",
			url: "scvmanager/ajax",
			success: function(data, dataType)
			{
			{{--/*PHPから返ってきたデータの表示 */ --}}
				$("#cpuused").html($.parseJSON(data).cpu);
			},
			error: function(XMLHttpRequest, textStatus, errorThrown)
			{
				//alert('Error : ' + errorThrown);
			}
		});

	});
</script>
@stop
