@extends('layout.default')
@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/ieprof.css') !!}">
@endsection
@section('content')
<div class="page-header">
  <h3>IE設定作成<span class="revobr-icon"></span></h3>
</div>
@foreach ($errors->all() as $error)
    <p style="color:red">{{$error}}</p>
@endforeach
<button type="button" onclick="location.href='{{URL::to('/scvmanager/ieprof')}}'">戻る</button>
{{Form::open(['action' => 'IeProfController@store'])}}

<div class="table-responsive">
  <table class="table table-condensed table-bordered">
    <tr>
      <th>IE設定名</th>
      <td>
        IE_{{Form::text('name')}}
        <span id="ieprofile-name-tooltip"></span>
      </td>
    </tr>
    <tr>
      <th>プロファイルを保存する</th>
      <td>{{Form::checkbox('save_profile')}}<td>
    </tr>
    <tr>
      <th>WindowsDefender</th>
      <td>{{Form::select('use_windows_defender', ['利用しない', 'スキャンのみ', 'スキャンしてダウンロード'])}}</td>
    </tr>
    <tr>
      <th>ホームページ</th>
      <td>{{Form::text('homepage')}}</td>
    </tr>
    <tr>
      <th rowspan="3">プロキシ設定</th>
      <td>
        <span class="proxy">プロキシホスト</span>{{Form::text('http_proxy_host')}}
      </td>
    </tr>
    <tr>
      <td>
        <span class="proxy">プロキシポート</span>{{Form::number('http_proxy_port', null, ['min' => 0, 'max' => 65535])}}
      </td>
    </tr>
    <tr>
      <td>
        <span class="proxy">プロキシ無しで接続</span>{{Form::text('pass_through')}}
      </td>
    </tr>
  </table>
  </table>
{{Form::submit()}}
@stop
@section('script')
<script src="{!! asset('js/tooltips.js') !!}"></script>
@endsection