<!-- scv/resources/views/layout/default.blade.php -->
<!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  {{-- 上記の3行は一番最初に記述すること --}}
  <meta http-equiv="Pragma" content="no-cache" />
  <meta http-equiv="cache-control" content="no-cache" />
  <meta http-equiv="expires" content="0" />
  <meta http-equiv="Content-Security-Policy" content="script-src 'self' 'unsafe-inline'">

  <meta name="description" content="Secure Console Vitrual">
  <meta name="author" content="tnakamura@jscom.co.jp">
  <title>SCV</title>

  <!-- Bootstrap core CSS -->
  <link href="{!! asset('css/bootstrap.min.css') !!}" rel="stylesheet">

  <!-- common style -->
  <link rel="stylesheet" href="{!! asset('css/scvcommon.css') !!}" type="text/css">

  @yield('head')
</head>
<body>
<main>
  <nav class="navbar navbar-inverse navbar-fixed-top">
      <div class="navbar-header">
        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
          <span class="sr-only">SCV Manager</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
        @if(Auth::check() && empty(Auth::user()->tmp_pwd))
          <a class="navbar-brand" href="{{URL::to('/scvmanager')}}">SCV Manager</a>
        @else
          <a class="navbar-brand" href="">SCV Manager</a>
        @endif
      </div>
      <div id="navbar" class="navbar-collapse collapse">
        <ul class="nav navbar-nav">
          @if(Auth::check())
            @if(empty(Auth::user()->tmp_pwd))
              @if(Auth::user()->organization_id == "1")
                <li class="dropdown">
                  <a href="{{URL::to('/scvmanager/scvconf')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">システム設定</a>
                  <ul class="dropdown-menu hidden-xs" style="width:22em;">
                    <li><a href="{{URL::to('/scvmanager/scvconf/system/edit')}}">SYSTEMの変更</a></li>
                    <li><a href="{{URL::to('/scvmanager/users')}}">管理者アカウント管理</a></li>
                    <li><a href="{{URL::to('/scvmanager/scvxlicense/list')}}">ライセンス情報</a></li>
                    <li><a href="{{URL::to('/scvmanager/scvxlicense')}}">ライセンス登録</a></li>
                    <li><a href="{{URL::to('/scvmanager/profile_group')}}">プロファイルテンプレート管理<span class="scvx-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/pac')}}">Pacファイルアップロード<span class="scvx-icon pull-right"></span><span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/serverlist')}}">URLリダイレクト管理<span class="scvx-icon pull-right"></span><span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/appsettings')}}">アプリケーションマスタ管理<span class="revodt-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/emergency_mode')}}">災害時モード管理</a></li>
                    @if(App\Libs\ConfHelper::isPpuMaster())
                      <li><a href="{{URL::to('/scvmanager/ppu')}}">PPUメール管理</a></li>
                    @endif
                  </ul>
                </li>
              @else
              <li class="dropdown">
                <a href="{{URL::to('/scvmanager/users')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">管理者アカウント管理</a>
              </li>
              <li><a href="{{URL::to('/scvmanager/profile_group')}}">プロファイルテンプレート管理</a></li>
              @endif
                <li class="dropdown">
                  @if(Auth::user()->organization_id == "1")
                  <a href="{{URL::to('/scvmanager/organization')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">組織管理</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="{{URL::to('/scvmanager/organization/create')}}">組織作成</a></li>
                  </ul>
                  @else
                  <a href="{{URL::to('/scvmanager/organization/'. Auth::user()->organization)}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">組織管理</a>
                  @endif
                </li>
                <li class="dropdown">
                  <a href="{{URL::to('/scvmanager/scvgroups')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">グループ管理</a>
                  <ul class="dropdown-menu hidden-xs" style="width:16em;">
                    <li><a href="{{URL::to('/scvmanager/scvgroups/create')}}">グループ作成</a></li>
                    <li><a href="{{URL::to('/scvmanager/firefoxprof')}}">Firefox設定<span class="scvx-icon pull-right"></span><span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/scvx_chrome_settings')}}">SCVX Chrome設定<span class="scvx-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/share')}}">共有フォルダ設定</a></li>
                    @if(Auth::user()->organization_id == "1")
                    <li><a href="{{URL::to('/scvmanager/scvgroups/csv')}}">グループ一括登録</a></li>
                    <li><a href="{{URL::to('/scvmanager/br_settings')}}">RevoBrowser設定<span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/visionprof')}}">デスクトップ設定<span class="revodt-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/vpn_settings')}}">VPN設定<span class="revobr-icon pull-right"></span><span class="revodt-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/proxy_settings')}}">Proxy設定<span class="revobr-icon pull-right"></span><span class="revodt-icon pull-right"></span></a></li>
                    @endif
                  </ul>
                </li>
                <li class="dropdown">
                  <a href="{{URL::to('/scvmanager/scvusers')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">ユーザ管理</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="{{URL::to('/scvmanager/scvusers/create')}}">ユーザ作成</a></li>
                    @if(Auth::user()->organization_id == "1")
                    <li><a href="{{URL::to('/scvmanager/batch')}}">ユーザ一括登録</a></li>
                    @endif
                  </ul>
                </li>
                @if(Auth::user()->organization_id == "1")
                <li class="dropdown">
                  <a href="{{URL::to('/scvmanager/devices')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">端末管理</a>
                  <ul class="dropdown-menu hidden-xs" style="width:20em;">
                    <li><a href="{{URL::to('/scvmanager/devices/revobr/policy')}}">RevoWorks Browser Updater<span class="revobr-icon pull-right"></span></a></li>
                    <li><a href="{{URL::to('/scvmanager/devices/revodt_list')}}">RevoWorks Desktop 端末一覧<span class="revodt-icon pull-right"></span></a></li>
                  </ul>
                </li>
                @endif
              @if(Auth::user()->organization_id == "1")
                <li class="dropdown">
                  <a href="{{URL::to('/scvmanager/reports')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">レポート</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="{{URL::to('/scvmanager/logsearch')}}">ユーザログ検索</a></li>
                    <li><a href="{{URL::to('/scvmanager/filelogsearch')}}">ファイルログ検索</a></li>
                    <li><a href="{{URL::to('/scvmanager/updater_log')}}">アップデータログ検索</a></li>
                    <li><a href="{{URL::to('/scvmanager/reportrank')}}">ユーザランキング</a></li>
                    <li><a href="{{URL::to('/scvmanager/reportutil')}}">ユーザ利用状況</a></li>
                    <li><a href="{{URL::to('/scvmanager/reportperf')}}">サーバ稼動状況</a></li>
                  </ul>
                </li>
                <li><a href="{{URL::to('/about')}}">SCVについて</a></li>
              @else
                <li class="dropdown">
                  <a href="{{URL::to('/scvmanager/reports')}}" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">レポート</a>
                  <ul class="dropdown-menu hidden-xs">
                    <li><a href="{{URL::to('/scvmanager/reportrank')}}">ユーザランキング</a></li>
                  </ul>
                </li>
              @endif
            @endif
          @endif
        </ul>
        @if(!Auth::guest())
        {{-- グローバルナビが全て表示されているとき --}}
        <ul class="nav navbar-nav navbar-right hidden-xs">
          @if(Auth::user()->organization_id == "1")
            <li data-toggle="bottom" data-placement="right" title="SCVについて"><a href="{{URL::to('/about')}}"><span class="glyphicon glyphicon-question-sign"></span></a></li>
          @endif
          <li><a href="#" data-toggle="bottom" data-placement="right" title="{{Auth::user()->username}}"><span class="glyphicon glyphicon-user"></span></a></li>
          <li data-toggle="bottom" data-placement="right" title="ログアウト"><a href="{{URL::to('/scvmanager/logout')}}"><span class="glyphicon glyphicon-log-out"></span></a></li>
          <li>&nbsp;&nbsp;&nbsp;</li>
        </ul>
        {{-- グローバルナビが折りたたまれたとき --}}
        <ul class="nav navbar-nav navbar-right visible-xs">
          @if(Auth::user()->organization_id == "1")
            <li><a href="{{URL::to('/about')}}">SCVについて</a></li>
          @endif
          <li><a href="#"><span class="glyphicon glyphicon-user"></span>{{Auth::user()->username}}</a></li>
          <li><a href="{{URL::to('/scvmanager/logout')}}">ログアウト</a></li>
        </ul>
        @endif
      </div>
  </nav>

  <div class="container-fluid">

    <div class="starter-template">
    </div>
@if(App\Libs\ClusterHelper::isCluster())
  {{-- クラスタ構成でslaveのアドレスが無い場合は以下のアラート表示 --}}
  @if(App\Libs\ClusterHelper::isMaster() && env('DB_HOST_SLAVE') == null)
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      .envにSlaveのホストを追記して下さい。
    </div>
  @endif

  {{-- クラスタ構成でMasterがActiveでない場合のアラート --}}
  @if( !App\Libs\ClusterHelper::isMasterActive() && !App\Libs\ClusterHelper::isMasterUpdating() )
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      MasterサーバがActiveではありません。
    </div>
  @endif

  @if(!App\Libs\ClusterHelper::isSlaveAlive())
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      Slaveサーバがダウンしています。
    </div>
  @elseif(App\Libs\ClusterHelper::isSlaveAlive() && !App\Libs\ClusterHelper::isSlaveActive() && !App\Libs\ClusterHelper::isSlaveUpdating() )
    <br>
    <div class="alert alert-danger alert-dismissible" role="alert">
      <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
      SlaveサーバがActiveではありません。
    </div>
  @endif
@endif

@if (!sem_acquire(sem_get(config('scv.csv_sem_key')), true))
<br>
<div class="alert alert-info alert-dismissible" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
    CSV一括処理を行っています。処理が完了するまでSCVManagerでの追加、変更、削除処理が行えません。
</div>
@endif

@if (App\Libs\LicenseHelper::isUserLicenseExeeded())
  <br>
  <div class="alert alert-danger alert-dismissible" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
    登録ユーザ数がライセンスの上限を超えています。ユーザの削除またはライセンスの追加を行ってください。
  </div>
@endif

@if (App\Libs\ConfHelper::is_illegal())
  <div class="alert alert-danger alert-dismissible" role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="閉じる"><span aria-hidden="true">×</span></button>
    認証方式の設定が誤っています。
  </div>
@else
    <div>@yield('content')</div>
@endif


  </div>
  <script type="text/javascript" src="{!! asset('js/jquery-1.11.3.min.js') !!}"></script>
  <script type="text/javascript" src="{!! asset('js/Chart.min.js') !!}"></script>
  <script src="{!! asset('js/bootstrap.min.js') !!}"></script>
  <script src="{!! asset('js/scvmanager/layout.js') !!}"></script>
  @yield('script')
</main>
<footer>
    <p class="pull-center"><small>{{config('scv.copyright')}}</small></p>
</footer>
</body>
</html>
