<!-- scv/resources/views/license_upload/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>ライセンス登録</h3>
</div>
@if(isset($return_array))
  @foreach($return_array as $ret)
    {!! $ret !!}
  @endforeach
@endif
@foreach ($errors->all() as $error)
  <p style="color:red">{{ $error }}</p>
@endforeach
<button type="button" onclick="location.href='{{URL::to('/scvmanager/scvxlicense/list')}}'">戻る</button>
<form action="{{URL::to('/scvmanager/scvxlicense/upload')}}" method="post" enctype="multipart/form-data">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
    <input type="file" name="license[]" size="30" multiple accept="text/plain" required>
    <div class="list">
      <ul></ul>
    </div>
  <input type="submit" value="追加">
</form>


@endsection
@section('script')
<script type="text/javascript">
  $('input[type="file"]').change(function(e){
    $('.list > ul').empty();
    var value = this.value;
    var files = e.target.files;
    var inputVal = "";
    for(var i = 0; i < files.length; i++){
      var fileVal = files[i];
      $('.list > ul').append('<li>'+fileVal.name+'</li>');
    }
  });
</script>
@endsection