<!-- scv/resources/views/license_upload/index.blade.php -->
@extends('layout.default')
@section('content')

<?php
 const SCVX_LABEL = App\Http\Controllers\LicenseController::SCVX_LABEL; const EXT_LABEL = App\Http\Controllers\LicenseController::EXT_LABEL; const STZ_LABEL = App\Http\Controllers\LicenseController::STZ_LABEL; const TCK_LABEL = App\Http\Controllers\LicenseController::TCK_LABEL; const VCK_LABEL = App\Http\Controllers\LicenseController::VCK_LABEL; const REVOBR_LABEL = App\Http\Controllers\LicenseController::REVOBR_LABEL; const REVODT_LABEL = App\Http\Controllers\LicenseController::REVODT_LABEL; const RSTZ_LABEL = App\Http\Controllers\LicenseController::RSTZ_LABEL; const RTCK_LABEL = App\Http\Controllers\LicenseController::RTCK_LABEL; const RVCK_LABEL = App\Http\Controllers\LicenseController::RVCK_LABEL; const PPU_STZ_LABEL = App\Http\Controllers\LicenseController::PPU_STZ_LABEL; const PPU_VTC_LABEL = App\Http\Controllers\LicenseController::PPU_VTC_LABEL; $lic_scvx = []; $lic_revobr = []; $lic_revodt = []; $lic_ext = []; $lic_stz = []; $lic_tck = []; $lic_vck = []; $lic_rstz = []; $lic_rtck = []; $lic_rvck = []; $lic_ppu_stz = []; $lic_ppu_vtc = []; $scvx_core_total = 0; $revobr_core_total = 0; $revodt_core_total = 0; $lic_array = []; foreach ($licenses as $lic) { if (startsWith($lic->name, SCVX_LABEL)) { $lic_scvx[] = $lic; $scvx_core_total += (int)$lic->cores; } elseif (startsWith($lic->name, REVOBR_LABEL)) { $lic_revobr[] = $lic; $revobr_core_total += (int)$lic->cores; } elseif (startsWith($lic->name, REVODT_LABEL)) { $lic_revodt[] = $lic; $revodt_core_total += (int)$lic->cores; } elseif (startsWith($lic->name, EXT_LABEL)) { $lic_ext[] = $lic; } elseif (startsWith($lic->name, STZ_LABEL)) { $lic_stz[] = $lic; } elseif (startsWith($lic->name, TCK_LABEL)) { $lic_tck[] = $lic; } elseif (startsWith($lic->name, VCK_LABEL)) { $lic_vck[] = $lic; } elseif (startsWith($lic->name, RSTZ_LABEL)) { $lic_rstz[] = $lic; } elseif (startsWith($lic->name, RTCK_LABEL)) { $lic_rtck[] = $lic; } elseif (startsWith($lic->name, RVCK_LABEL)) { $lic_rvck[] = $lic; }elseif (startsWith($lic->name, PPU_STZ_LABEL)){ $lic_ppu_stz[] = $lic; }elseif (startsWith($lic->name, PPU_VTC_LABEL)){ $lic_ppu_vtc[] = $lic; } } $lic_array[SCVX_LABEL] = $lic_scvx; $lic_array[REVOBR_LABEL] = $lic_revobr; $lic_array[REVODT_LABEL] = $lic_revodt; $lic_array[EXT_LABEL] = $lic_ext; $lic_array[STZ_LABEL] = $lic_stz; $lic_array[VCK_LABEL] = $lic_vck; $lic_array[TCK_LABEL] = $lic_tck; $lic_array[RSTZ_LABEL] = $lic_rstz; $lic_array[RTCK_LABEL] = $lic_rtck; $lic_array[RVCK_LABEL] = $lic_rvck; $lic_array[PPU_STZ_LABEL] = $lic_ppu_stz; $lic_array[PPU_VTC_LABEL] = $lic_ppu_vtc; global $licfull; exec("scvlicense -licfull",$licfull); function getLicVal($key){ global $licfull; static $licdic = null; if ($licdic === null) { foreach ($licfull as $line) { if (preg_match("/^LicRun\.([^ \t]+).+=(.+)$/", $line, $m)) $licdic[$m[1]] = $m[2]; } } return isset($licdic[$key]) ? $licdic[$key] : ''; } function startsWith($haystack, $needle) { return strpos($haystack, $needle) === 0; } ?>

<div class="page-header">
  <h3>ライセンス情報</h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<form action="{{URL::to('/scvmanager/scvxlicense/delete')}}" method="POST">
  <button type="button" onclick="location.href='{{URL::to('/scvmanager/scvconf')}}'">戻る</button>
  <button type="button" onclick="location.href='/scvmanager/scvxlicense'">ライセンス登録</button>
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <table class="table table-condensed table-bordered table-striped">
    <caption>有効なライセンス</caption>
    <tr>
      <th>LicRun.hybrid</th>
      <td>{{ getLicVal('hybrid') }}</td>
      <th>LicRun.total_servers</th>
      <td>{{ getLicVal('total_servers') }}</td>
    </tr>
    <tr>
      <th>LicRun.total_cores</th>
      <td>{{ getLicVal('total_cores') }}</td>
      <th>LicRun.assigned_servers</th>
      <td>{{ getLicVal('assigned_servers') }}</td>
    </tr>
    <tr>
      <th>LicRun.assigned_cores</th>
      <td>{{ getLicVal('assigned_cores') }}</td>
      <th>LicRun.connectionlimit</th>
      <td>{{ getLicVal('connectionlimit') }}</td>
    </tr>
    <tr>
      <th>LicRun.connectionlimit120</th>
      <td>{{ getLicVal('connectionlimit120') }}</td>
      <th>LicRun.revobr_connectionlimit</th>
      <td>{{ getLicVal('revobr_connectionlimit') }}</td>
    </tr>
    <tr>
      <th>LicRun.revobr_bandlestzlimit</th>
      <td>{{ getLicVal('revobr_bandlestzlimit') }}</td>
      <th>LicRun.revobr_userlimit</th>
      <td>{{ getLicVal('revobr_userlimit') }}</td>
    </tr>
    <tr>
      <th>LicRun.revodt_connectionlimit</th>
      <td>{{ getLicVal('revodt_connectionlimit') }}</td>
      <th>LicRun.revodt_bandlestzlimit</th>
      <td>{{ getLicVal('revodt_bandlestzlimit') }}</td>
    </tr>
    <tr>
      <th>LicRun.revodt_userlimit</th>
      <td>{{ getLicVal('revodt_userlimit') }}</td>
      <th>LicRun.connectionexceeded</th>
      <td>{{ getLicVal('connectionexceeded') }}</td>
    </tr>
    <tr>
      <th>LicRun.checkmonth</th>
      <td>{{ getLicVal('checkmonth') }}</td>
      <th>LicRun.mode</th>
      <td>{{ getLicVal('mode') }}</td>
    </tr>
    <tr>
      <th>Licrun.stzlimit</th>
      <td>{{ getLicVal('stzlimit') }}</td>
      <th>Licrun.vcklimit</th>
      <td>{{ getLicVal('vcklimit') }}</td>
    </tr>
    <tr>
      <th>Licrun.tcklimit</th>
      <td>{{ getLicVal('tcklimit') }}</td>
      <th></th>
      <td></td>
    </tr>
  </table>

  @foreach($lic_array as $key => $lic)
    @if($lic)
      <table class="table table-condensed table-bordered table-striped">
        @if ($key == SCVX_LABEL)
          <caption>{{ $key }} ライセンス ( total {{ $scvx_core_total }} cores )</caption>
        @elseif (strpos($key, REVOBR_LABEL) === 0)
          <caption>{{ $key }} ライセンス ( total {{$revobr_core_total}} cores )</caption>
        @elseif (strpos($key, REVODT_LABEL) === 0)
          <caption>{{ $key }} ライセンス ( total {{$revodt_core_total}} cores )</caption>
        @else
          <caption>{{ $key }} ライセンス</caption>
        @endif
        <tr>
          <th class="col-xs-3 col-ms-3 col-md-3 col-lg-3">ライセンス名</th>
          <th class="col-xs-2 col-ms-2 col-md-2 col-lg-2">シリアルNo.</th>
          <th class="col-xs-1 col-ms-1 col-md-1 col-lg-1">タイプ</th>
          <th class="col-xs-1 col-ms-1 col-md-1 col-lg-1">ライセンス数</th>
          <th class="col-xs-2 col-ms-2 col-md-2 col-lg-2">ライセンスユーザ</th>
          <th class="col-xs-2 col-ms-2 col-md-2 col-lg-2">有効期限</th>
          <th class="col-xs-1 col-ms-1 col-md-1 col-lg-1"></th>
        </tr>
      @foreach($lic as $license)
        <tr class="lic_data">
          <td class="name">{{$license->name}}</td>
          <td class="serial">{{$license->serial}}</td>
          <td>{{$license->type}}</td>
          <td>{{$license->cores}}</td>
          <td>{{$license->company}}</td>
          <td class="expiration">{{$license->expiration}}</td>
          <td class="text-center"><button class="del_btn" type="submit" name="serial" value="{{$license->serial}}">削除</button></td>
        </tr>
      @endforeach
      </table>
    @endif
  @endforeach
</form>

@endsection
@section('script')
<script type="text/javascript">
  var now = new Date().getTime();
  $('.lic_data').find(".expiration").each(function(){
    var d = Date.parse($(this).text());
    if(d < now){
      $(this).parent().addClass('danger');
    }
  });
  $('.del_btn').on('click',function(){
    var licName   = $(this).parent().siblings('.name').text();
    var licSerial = $(this).parent().siblings('.serial').text();

    var expDate   = Date.parse($(this).parent().siblings('.expiration').text());
    var msgPrefix = '';
    if(expDate > now){
      msgPrefix = '有効なライセンスです\n';
    }
    var msg = msgPrefix + 'ライセンス名      : ' + licName + '\nシリアルナンバー : ' + licSerial + '\n削除してよろしいですか？';
    if(!confirm(msg)){
      return false;
    }
  });
</script>
@endsection
