<!-- scv/resources/views/logsearch/filelog.blade.php -->
@extends('layout.default')
@section('head')
<link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
<link rel="stylesheet" href="{!! asset('css/search-box.css') !!}">
@stop
@section('content')

<div class="page-header">
  <h3>ファイルログ検索</h3>
</div>

<button type="button" onclick="location.href='/scvmanager/reports'">戻る</button>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
  {!! Session::forget('flash_msg') !!}
@endif
<p>{{ $filelogs->count() }} 件ヒットしました。</p>

{{ Form::open(['method' => 'post']) }}
    <div class="search-box">
            期間 : 
            {{ Form::text('start_date', $start_date, ['class' => 'datetime', 'readonly']) }} ～
            {{ Form::text('end_date',   $end_date,   ['class' => 'datetime', 'readonly']) }}
            {{ Form::text('keyword',    $keyword,    ['placeholder' => '検索ワード']) }}
            {{ Form::submit('検索',        ['name' => 'search']) }}
            {{ Form::submit('この条件でDL', ['name' => 'download']) }}
    </div>
{{ Form::close() }}
<table class="table table-striped table-condensed table-bordered">
    <tr>
        <th>操作</th>
        <th>組織名</th>
        <th>ユーザ名</th>
        <th>IPアドレス</th>
        <th>ファイル名</th>
        <th>ファイルサイズ(KB)</th>
        <th>処理時間(秒)</th>
        <th>ステータス</th>
        <th>開始時間</th>
        @if ($flow_available)
            <th>方向</th>
            <th>申請者</th>
            <th>承認者</th>
            <th>申請者コメント</th>
            <th>申請日時</th>
            <th>承認日時</th>
            <th>承認者コメント</th>
        @endif
    </tr>
@foreach ($filelogs as $line)
    <tr>
    {{-- 操作 --}}
        <td>{{ $line->operation }}</td>
    {{-- 組織名 --}}
    @if ($line->filelogs_organization)
        <td>{{ $line->filelogs_organization }}</td>
    @else
        <td>{{ $line->scvflow_logs_organization }}</td>
    @endif
    {{-- ユーザ名 --}}
    @if ($line->filelogs_user)
        <td>{{ $line->filelogs_user }}</td>
    @else
        <td>{{ $line->scvflow_logs_user }}</td>
    @endif
    {{-- IPアドレス --}}
    @if ($line->filelogs_ipaddress)
        <td>{{ $line->filelogs_ipaddress }}</td>
    @else
        <td>{{ $line->scvflow_logs_ipaddress }}</td>
    @endif
    {{-- ファイル名 --}}
    @if ($line->filelogs_filename)
        <td>{{ $line->filelogs_filename }}</td>
    @else
        <td>{{ $line->scvflow_logs_filename }}</td>
    @endif
    {{-- ファイルサイズ(KB) --}}
    @if ($line->filelogs_filename)
        <td align="right">{{ number_format($line->filelogs_filesize) }} KB</td>
    @else
        <td align="right">{{ number_format($line->scvflow_logs_filesize / 1024 + 1) }} KB</td>
    @endif
    {{-- 処理時間(秒) --}}
    @if ($line->operation)
        <td align="right"> {{ $line->elapsed_time }} </td>
    @else
        <td align="right"> - </td>
    @endif
    {{-- ステータス --}}
    @if ($line->filelogs_status)
        <td align="center">{{ $line->filelogs_status }}</td>
    @else
        @if ($line->scvflow_logs_status === 'waiting')
            <td align="center">承認待ち</td>
        @elseif ($line->scvflow_logs_status === 'canceled')
            <td align="center">申請取消</td>
        @elseif ($line->scvflow_logs_status === 'permitted')
            <td align="center">承認済み</td>
        @elseif ($line->scvflow_logs_status === 'denied')
            <td align="center">否認済み</td>
        @endif
    @endif
    {{-- 開始時間 --}}
    @if (!$line->scvflow_logs_user)
        <td>{{ $line->created_at }}</td>
    @else
        <td>{{ $line->requested_at }}</td>
    @endif
    @if ($flow_available)
        {{-- 方向 --}}
            <td>{{ $line->action_type }}</td>
        {{-- 申請者 --}}
            <td>{{ $line->applicant_summary }}</td>
        {{-- 承認者 --}}
            <td>{{ $line->authorizer_summary }}</td>
        {{-- 申請者コメント --}}
            <td>{{ $line->scvflow_logs_comment }}</td>
        {{-- 申請日時 --}}
            <td>{{ $line->requested_at }}</td>
        {{-- 承認日時（承認待ちのとき "0000-00-00" のように表示されるので判定を入れる） --}}
        @if (strpos($line->authorized_at, '00') !== 0)
            <td>{{ $line->authorized_at }}</td>
        @else
            <td>-</td>
        @endif
        {{-- 承認者コメント --}}
        <td>{{ $line->why_denied }}</td>
    @endif
    </tr>
@endforeach
</table>
@stop
@section('script')
<script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
<script src="{!! asset('js/search-box.js') !!}"></script>
@stop