<!-- scv/resources/views/logsearch/show.blade.php -->
@extends('layout.default')
@section('head')
<link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
<link rel="stylesheet" href="{!! asset('css/search-box.css') !!}">
@stop
@section('content')

<div class="page-header">
  <h3>ユーザログ検索</h3>
</div>
<button type="button" onclick="location.href='/scvmanager/reports'">戻る</button>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
  {!! Session::forget('flash_msg') !!}
@endif
<p>{{ $clientlogs->count() }} 件ヒットしました。</p>

{{ Form::open(['method' => 'post']) }}
    <div class="search-box">
            期間 : 
            {{ Form::text('start_date', $start_date, ['class' => 'datetime', 'readonly']) }} ～
            {{ Form::text('end_date',   $end_date,   ['class' => 'datetime', 'readonly']) }}
            {{ Form::text('keyword',    $keyword,    ['placeholder' => '検索ワード']) }}
            {{ Form::submit('検索',        ['name' => 'search']) }}
            {{ Form::submit('この条件でDL', ['name' => 'download']) }}
    </div>
{{ Form::close() }}
    <table class="table table-striped table-condensed table-bordered">
        <tr>
            <th>ステータス</th>
            <th>サーバ</th>
            <th>組織名</th>
            <th>ユーザ名</th>
            <th>ホスト名</th>
            <th>スタート</th>
            <th>起動秒</th>
            <th>コンテナ削除</th>
            <th>削除理由</th>
            <th>利用分</th>
            <th>ロードアベレージ</th>
            <th>コンテナ数</th>
        </tr>
    @foreach ($clientlogs as $line)
    <?php
 $time1 = strtotime($line->scvdirect_started); $time2 = strtotime($line->appstart_started); $time3 = strtotime($line->container_removed); $diff1 = 0; $diff2 = 0; if($time2>0){ $diff1 = $time2 - $time1; } if($time3>0){ $diff2 = ($time3 - $time1)/60; } ?>
        <tr>
            <td>{{ $line->statmsg }}</a></td>
            <td>{{ $line->scvserver }}</td>
            <td>{{ $line->organization_name }}</td>
            <td>{{ $line->scvuser }}</td>
            <td>{{ $line->hostname }}</a></td>
            <td>{{ $line->scvdirect_started }}</td>
            <td align="right">{{ $diff1 }}</td>
            <td>{{ $line->container_removed }}</td>
            <td>{{ $line->container_removed_reason }}</td>
            <td align="right">{{ number_format($diff2, 1) }}</td>
            <td align="right">{{ $line->cpuloadavg }}</td>
            <td align="right">{{ $line->containers }}</td>
        </tr>
    @endforeach
    </table>
@stop
@section('script')
<script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
<script src="{!! asset('js/search-box.js') !!}"></script>
@stop