<!-- scv/resources/views/logsearch/show.blade.php -->
@extends('layout.default')
@section('head')
<link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
<link rel="stylesheet" href="{!! asset('css/search-box.css') !!}">
@stop
@section('content')

<div class="page-header">
    <h3>アップデータログ検索</h3>
</div>
<button type="button" onclick="location.href='/scvmanager/reports'">戻る</button>

@if(Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg')!!}</p>
  {!! Session::forget('flash_msg') !!}
@endif

@isset($updaterlogs)
    <p> {{$updaterlogs->count()}} 件ヒットしました。</p>
@endisset

{{ Form::open(['method' => 'post']) }}
    <div class="search-box">
        期間 : 
        {{ Form::text('start_date', date('Y-m-d H:00', strtotime('-23 hour')), ['class' => 'datetime', 'readonly']) }} ～
        {{ Form::text('end_date', date('Y-m-d H:00', strtotime('+1 hour')),   ['class' => 'datetime', 'readonly']) }}
        {{ Form::text('keyword', null, ['placeholder' => '検索ワード']) }}
        {{ Form::submit('検索', ['name' => 'search', 'formaction' => '/scvmanager/updater_log']) }}
        {{ Form::submit('この条件でDL', ['name' => 'download', 'formaction' => '/scvmanager/updater_log/csv']) }}
    </div>
{{ Form::close() }}

<table class="table table-striped table-condensed table-bordered">
    <tr>
        <th>ユーザ名</th>
        <th>組織名</th>
        <th>IPアドレス</th>
        <th>ホスト名</th>
        <th>OS</th>
        <th>アップデータ</th>
        <th>クライアント</th>
        <th>Firefox</th>
        <th>Chrome</th>
        <th>Extension</th>
        <th>日時</th>
    </tr>
    @isset($updaterlogs)
        @foreach ($updaterlogs as $log)
            <tr>
                <td>{{$log->user}}</td>
                <td>{{$log->organization}}</td>
                <td>{{$log->ip}}</td>
                <td>{{$log->hostname}}</td>
                <td>{{$log->os}}</td>
                <td>{{$log->current_updater_version}}</td>
                <td>{{$log->current_client_version}}</td>
                <td>{{$log->current_firefox_version}}</td>
                <td>{{$log->current_chrome_version}}</td>
                <td>{{$log->current_extension_version}}</td>
                <td>{{$log->created_at}}</td>
            </tr>
        @endforeach
    @endisset
</table>

@endsection
@section('script')
  <script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
  <script src="{!! asset('js/search-box.js') !!}"></script>
@endsection
