<!-- scv/resources/views/managed_bookmarks/edit.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/bookmark.css') !!}">
@endsection

@section('content')

  <div class="page-header">
    <h3>Bookmark設定変更<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  <button onclick="location.href='{{ route('managed_bookmarks.index') }}'">戻る</button>

  {{ Form::model($setting, ['url' => route('managed_bookmarks.update', ['managed_bookmark' => $setting->id]), 'method' => 'put']) }}
  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名 <span style="color: red">*</span></th>
      <td>{{ \App\Models\ManagedBookmark::NAME_PREFIX }}{{ Form::text('namebody', $setting->namebody, ['required' => 'required']) }}</td>
    </tr>
  </table>
  <div>
    <h5>
      Bookmark設定
      <span class="glyphicon glyphicon-question-sign text-info" id="bookmark_setting_pop" data-toggle="popover" title="Bookmark設定<span class='revobr-icon'></span>"></span>
      <a data-toggle="modal" data-target="#bookmark-modal" data-backdrop="static" data-clickbutton="new">
        <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
      </a>
    </h5>
    <table id="bookmarks-table" class="table table-condensed table-bordered" data-hideplace="true">
      <input type="hidden" name="bookmarks">
      <tr>
        <th>No.</th>
        <th>ブックマーク名</th>
        <th>URL</th>
        <th>フォルダ名</th>
        <th></th>
        <th></th>
      </tr>
    </table>
  </div>
  {{ Form::submit('更新') }}
  {{ Form::close() }}

@include('managed_bookmarks.modal', ['hideplace' => true])

@stop

@section('script')
  <script type="text/javascript" src="{!! asset('js/jquery-ui.min.js') !!}"></script>
  <script src="{!! asset('js/tooltips.js') !!}"></script>
  <script>
    var bookmarks = JSON.parse(@json(old('bookmarks', $setting->bookmarks) ?? null));
    bookmarks = bookmarks ? bookmarks : [];
  </script>
  <script src="{!! asset('js/scvmanager/bookmark.js') !!}"></script>
@stop
