<!-- scv/resources/views/managed_bookmarks/index.blade.php -->
@extends('layout.default')

@section('content')

  <div class="page-header">
    <h3>Bookmark設定<span class="revobr-icon"></span></h3>
  </div>

  <p>RevoBrowserで使用するGoogleChrome・EdgeのBookmarkの設定を管理します。</p>
  @if (Session::has('success'))
    <p class="text-info">{!! Session::get('success') !!}</p>
  @endif

  <button onclick="location.href='{{ route('br_settings.index') }}'">戻る</button>
  <button onclick="location.href='{{ route('managed_bookmarks.create') }}'">作成</button>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered table-striped">
      <tr>
        <th>id</th>
        <th>設定名</th>
        <th>ブックマーク</th>
      </tr>
      @foreach ($settings as $s)
        <tr>
          <td>{{ $s->id }}</td>
          <td><a href="{{ route('managed_bookmarks.show', ['managed_bookmark' => $s->id]) }}">{{ $s->name }}</a></td>
          <td>
            <?php
 if ($s->bookmarks) { $bookmark = json_decode($s->bookmarks); foreach ($bookmark as $b) { echo $b->Title . '<br>'; } } ?>
          </td>
        </tr>
      @endforeach
    </table>
  </div>
@stop

@section('script')
  <script>
  </script>
@stop
