<!-- scv/resources/views/managed_bookmarks/show.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/bookmark.css') !!}">
@endsection

@section('content')

  <div class="page-header">
    <h3>Bookmark設定詳細<span class="revobr-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif
  <?php
 $bookmarks = $setting->bookmarks ? json_decode($setting->bookmarks) : []; ?>

  {{ Form::open(['url' => route('managed_bookmarks.destroy', ['managed_bookmark' => $setting->id]), 'method' => 'delete']) }}
  <button type="button" onclick="location.href='{{ route('managed_bookmarks.index') }}'">戻る</button>
  <button type="button" onclick="location.href='{{ route('managed_bookmarks.edit', ['managed_bookmark' => $setting->id]) }}'">編集</button>
  {{ Form::hidden('id', $setting->id) }}
  {{ Form::submit('削除', ['onclick' => 'return check();']) }}
  {{ Form::close() }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名</th>
      <td>{{ $setting->name }}</td>
    </tr>
  </table>

  @if($bookmarks)
  <br>
  <table class="table table-condensed table-bordered">
    <tbody>
      <tr>
        <th colspan="4" class="gray">ブックマーク</th>
      </tr>
      <tr>
        <th>ブックマーク名</th>
        <th>URL</th>
        <th>フォルダ名</th>
      </tr>
      @foreach ($bookmarks as $b)
        <tr>
          <td>{{$b->Title}}</td>
          <td>{{$b->URL}}</td>
          <td>{{$b->Folder}}</td>
        </tr>
      @endforeach
    </tbody>
  </table>
  @endif

@stop

@section('script')
  <script>
    $(function() {
      $("form").submit(function() {
        if (confirm("{{ $setting->name }}を削除しますか？")) {
          return true;
        } else {
          return false;
        }
      });
    });

  </script>
@stop
