<!-- scv/resources/views/organization/edit.blade.php -->
@extends('layout.default')

@section('head')
<style>
  .manager-table th{
    width: 150px;
  }
</style>
@stop

@section('content')

<div class="page-header">
  <h3>組織変更</h3>
</div>

@if ($errors->any())
  <p style="color:red">
    @foreach ($errors->all() as $error)
      {{ $error }}<br>
    @endforeach
  </p>
@endif

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

{{ Form::model($organization, ['route' => ['organization.update', $organization->name], 'method' => 'put']) }}
  {{ Form::hidden('id', $organization->id) }}
  <button type="button" onclick="move_back()">戻る</button>
  @if ($is_admin)
    <div class="table">
      <table class="table table-condensed table-bordered manager-table">
        <tr>
          <th>組織名</th>
          <td>
            {{ Form::text('name', null, ['placeholder' => '<ORGANIZATION NAME>']) }}
            <span id="organization-name"></span>
          </td>
        </tr>
        <tr>
          <th>最大接続数</th>
          <td>
            {{ Form::number('max_limit', null, ['min' => -1, 'max' => 99999]) }}
            <span id="organization-max-limit"></span>
          </td>
        </tr>
        <tr>
          <th>利用オプション</th>
          <td>
            <label>{{ Form::checkbox('enable_stz') }} SCVX Sanitizer</label><br>
            <label>{{ Form::checkbox('enable_vck') }} Virus Checker</label><br>
            <label>{{ Form::checkbox('enable_tck') }} Threat Checker</label><br>
          </td>
        </tr>
        <tr>
          <th>備考</th>
          <td>
            {{ Form::text('comment') }}
          </td>
        </tr>
      </table>
    </div>
  @else
  {{-- 組織管理者の場合は変更不可 --}}
  {{ Form::hidden('name') }}
  {{ Form::hidden('max_limit') }}
  {{ Form::hidden('comment') }}
  {{ Form::hidden('enable_stz') }}
  {{ Form::hidden('enable_vck') }}
  {{ Form::hidden('enable_tck') }}
  <div class="table">
    <table class="table table-condensed table-bordered manager-table">
      <tr>
        <th>組織名</th>
        <td>{{$organization->name}}</td>
      </tr>
      <tr>
        <th>同時接続数</th>
        <td>{{$organization->max_limit}}</td>
      </tr>
      <tr>
        <th>備考</th>
        <td>{{$organization->comment}}</td>
      </tr>
      <tr>
        <th>利用オプション</th>
        <td>
          SCVX Sanitizer: {{ $organization->enable_stz ? '利用可能' : '利用不可' }}<br>
          Virus Checker: {{ $organization->enable_vck ? '利用可能' : '利用不可' }}<br>
          Threat Checker: {{ $organization->enable_tck ? '利用可能' : '利用不可' }}<br>
        </td>
      </tr>
    </table>
  </div>
  @endif

  @if (\App\Libs\ConfHelper::usingPassword())
    <div class="page-header">
      <h4>パスワードポリシー設定</h4>
    </div>
    <table class="table table-condensed table-bordered pwd-policy-wrap">
      <tr>
        <th>パスワードの最低文字数</th>
        <td>
          {{ Form::number('pwd_length', null, ['min' => 1, 'max' => $pwd_length_max]) }}文字
          <span id="organization-pwdpolicy-length"></span>
        </td>
      </tr>
      <tr>
        <th>パスワード変更の最低間隔</th>
        <td>
          {{ Form::number('pwd_min_term', null, ['min' => 0]) }}日間
          <span id="organization-pwdpolicy-min-term"></span>
        </td>
      </tr>
      <tr>
        <th>パスワードの有効期限</th>
        <td>
          {{ Form::number('pwd_max_term', null, ['min' => 0]) }}日間
          <span id="organization-pwdpolicy-max-term"></span>
        </td>
      </tr>
      <tr>
        <th>期限切れ警告の表示期間</th>
        <td>
          {{ Form::number('pwd_warning_term', null, ['min' => 0]) }}日前から
          <span id="organization-pwdpolicy-warning-term"></span>
        </td>
      </tr>
      <tr>
        <th>重複チェックを行う世代数</th>
        <td>
          {{ Form::number('pwd_generation_limit', null, ['min' => 0, 'max' => $pwd_generation_limit_max]) }}件
          <span id="organization-pwdpolicy-generation-limit"></span>
          <span id="generation-warning" style="margin-left: 5px; color: red"></span>
        </td>
      </tr>
      <tr>
        <th>一定の複雑性を満たしたパスワードのみ許可する</th>
        <td>
          {{ Form::checkbox('pwd_complexity', true) }}
          <span id="organization-pwdpolicy-complexity"></span>
        </td>
      </tr>
      <tr>
        <th>パスワードに含めることのできない単語</th>
        <td>
          {{ Form::textarea('pwd_ngwords', null, ['placeholder' => "password\r\nabcd\r\n1234"]) }}<br>
          <span id="organization-pwdpolicy-ngwords"></span>
        </td>
      </tr>
      <tr>
        <th>アカウントロックしきい値</th>
        <td>
          {{ Form::number('lockout_threshold', null, ['min' => 0]) }}回
          <span id="organization-lockhout_threshold"></span>
        </td>
      </tr>
    </table>
  @endif
  {{ Form::submit('登録') }}
{{ Form::close() }}
@stop

@section('script')
<script src="{!! asset('js/scvmanager/organization.js') !!}"></script>
<script src="{!! asset('js/tooltips.js') !!}"></script>
@stop
