<!-- scv/resources/views/organization/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>組織管理</h3>
</div>

{{-- 一応ADMINと非ADMINで表示管理しているが、現状ではそもそもADMIN以外はこのページを表示できない --}}
@if ($is_admin)
  <p style="color:red">
    組織はマルチテナント管理を行う場合にのみ使用してください。<br>
    単一の会社や組織の場合はデフォルトのADMIN組織のみで使用することをお勧めします。
  </p>
@endif

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

@if ($errors->any())
  <p style="color:red">
    @foreach ($errors->all() as $error)
      {{ $error }}<br>
    @endforeach
  </p>
@endif

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

@if ($is_admin)
  <button type="button" onclick="move_under('create')">作成</button>
@endif

<div class="text-center">{!! $organizations->render() !!}</div>

<div class="table-responsive">
  <table class="table table-condensed table-bordered table-striped">
    <tr>
      <th>組織名</th>
      <th>備考</th>
      <th>作成日</th>
      <th>更新日</th>
    </tr>
    @foreach($organizations as $organization)
    <tr>
      <td><a href="organization/{{ $organization->name }}">{{ $organization->name }}</a></td>
      <td>{{ $organization->comment }}</td>
      <td>{{ $organization->created_at }}</td>
      <td>{{ $organization->updated_at }}</td>
    </tr>
    @endforeach
  </table>
</div>

<div class="text-center">{!! $organizations->render() !!}</div>
@stop

@section('script')
<script src="{!! asset('js/scvmanager/organization.js') !!}"></script>
<script src="{!! asset('js/tooltips.js') !!}"></script>
@stop