<!-- scv/resources/views/organization/show.blade.php -->
@extends('layout.default')

@section('head')
<style>
  .manager-table th{
    width: 150px;
  }
</style>
@stop

@section('content')

<div class="page-header">
  <h3>組織詳細</h3>
</div>

@if ($errors->any())
  <p style="color:red">
    @foreach ($errors->all() as $error)
      {{ $error }}<br>
    @endforeach
  </p>
@endif

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

{{ Form::model($organization, ['route' => ['organization.destroy', $organization->name], 'method' => 'delete', 'id' => 'delete']) }}
  {{ Form::hidden('name', $organization->name) }}
  @if ($is_admin)
    <button type="button" onclick="move_back()">戻る</button>
  @endif
  <button type="button" onclick="move_under('edit')">編集</button>
  @if ($is_admin)
    {{ Form::submit('削除') }}
  @endif

  <div class="table-responsive">
    <table class="table table-condensed table-bordered manager-table">
      <tr>
        <th>組織名</th>
        <td>{{ $organization->name }}</td>
        <th>備考</th>
        <td>{{ $organization->comment }}</td>
      </tr>
      <tr>
        <th>同時接続数</th>
        <td>{{ $organization->max_limit }}</td>
        <th>利用オプション</th>
        <td>
          SCVX Sanitizer: {{ $organization->enable_stz ? '利用可能' : '利用不可' }}<br>
          Virus Checker: {{ $organization->enable_vck ? '利用可能' : '利用不可' }}<br>
          Threat Checker: {{ $organization->enable_tck ? '利用可能' : '利用不可' }}<br>
        </td>
      </tr>
      <tr>
        <th>登録日</th>
        <td>{{ $organization->created_at }}</td>
        <th>更新日</th>
        <td>{{ $organization->updated_at }}</td>
      </tr>
    </table>
  </div>

  @if (\App\Libs\ConfHelper::usingPassword())
    <div class="page-header">
      <h4>パスワードポリシー設定</h4>
    </div>
    <table class="table table-condensed table-bordered pwd-policy-wrap">
      <tr>
        <th>パスワードの最低文字数</th>
        <td>{{ $organization->pwd_length }} 文字</td>
      </tr>
      <tr>
        <th>パスワード変更の最低間隔</th>
        <td>{{ $organization->pwd_min_term }} 日間</td>
      </tr>
      <tr>
        <th>パスワードの有効期限</th>
        <td>{{ $organization->pwd_max_term }} 日間</td>
      </tr>
      <tr>
        <th>期限切れ警告の表示期間</th>
        <td>{{ $organization->pwd_warning_term }} 日前から</td>
      </tr>
      <tr>
        <th>重複チェックを行う世代数</th>
        <td>{{ $organization->pwd_generation_limit }} 件</td>
      </tr>
      <tr>
        <th>一定の複雑性を満たしたパスワードのみ許可する</th>
        <td>{{ $organization->pwd_complexity ? '有効' : '無効' }}</td>
      </tr>
      <tr>
        <th>パスワードに含めることのできない単語</th>
        <td><pre>{{ $organization->pwd_ngwords }}</pre></td>
      </tr>
      <tr>
        <th>アカウントロックしきい値</th>
        <td>{{ $organization->lockout_threshold }} 回</td>
      </tr>
    </table>
  @endif
{{ Form::close() }}
@stop

@section('script')
<script src="{!! asset('js/scvmanager/organization.js') !!}"></script>
@stop
