<!-- scv/resources/views/pac/index.blade.php -->
@extends('layout.default')
@section('content')
<div class="page-header">
  <h3>PACファイルアップロード<span class="scvx-icon"></span><span class="revobr-icon"></span></h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

@if(Session::has('flash_msg'))
  {!! Session::get('flash_msg')!!}
@else
  <p>&nbsp;</p>
@endif


<button type="button" class="btn btn-default" onclick="location.href='/scvmanager/scvconf'">戻る</button>
<div class="row">
  <div class="col-md-4">
    <br>
    <form action="{{URL::to('/scvmanager/pac')}}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="_token" value="{{csrf_token()}}">
      <input type="file" id="lefile" name="pac" size="30" style="display:none">
      <div class="input-group">
        <input type="text" id="filename" class="form-control" placeholder="ファイルを選択して下さい">
        <span class="input-group-btn">
          <button type="button" class="btn btn-info" onclick="$('input&#91;id=lefile&#93;').click();">
            <span class="glyphicon glyphicon-file" aria-hidden="true"></span>
          </button>
        </span>
      </div>
      <br>
      <input type="submit" class="btn btn-primary" value="アップロード">
    </form>
  </div>
</div>
@endsection
@section('script')
  <script type="text/javascript">
    $(function(){
      $('input[id=lefile]').change(function() {
        $('#filename').val($(this).val().replace("C:\\fakepath\\", ""));
      });
    });
  </script>
@endsection
