<!-- scv/resources/views/profile_group/edit.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>プロファイルグループ変更<span class="scvx-icon"></span></h3>
</div>

@if ($errors->any())
  @foreach($errors->all() as $error)
    <p style="color:red">{{ $error }}</p>
  @endforeach
@endif

<button type="button" onclick="history.back()">戻る</button>
<form action="/scvmanager/profile_group/{{$scvgroup->id}}" method="POST">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
  <input name="_method" type="hidden" value="PUT">

  <div class="table-responsive">
  <table class="table table-condensed table-bordered">
    <tr>
      <th align="left" width="150" class="gray">組織名</th>
      <td>{{$organization_name}}</td>
    </tr>
    <tr>
      <th align="left" width="150" class="gray">グループ名</th>
      <td>{{$scvgroup->name}}</td>

      <th class="gray">Firefoxプロファイル</th>
      <td>
        <select name="firefoxprof">
        <option value="">設定しない</option>
        @foreach ($profiles as $fp)
          @if($fp->id == $scvgroup->firefoxprofile_id)
            <option value="{{$fp->id}}" selected>{{$fp->name}}</option>
          @else
            <option value="{{$fp->id}}">{{$fp->name}}</option>
          @endif
        @endforeach
        </select>
      </td>
    </tr>

    <tr>
      <th></th>
      <td><input type="submit" name="submit" value="更新"></td>
      <th></th>
      <td></td>
    </tr>
  </table>
  </div>
</form>
@endsection

