<!-- scv/resources/views/proxy_settings/create.blade.php -->
@extends('layout.default')

@section('head')
  <link rel="stylesheet" href="{!! asset('css/scvmanager/proxy_settings.css') !!}">
@endsection

@section('content')

  <div class="page-header">
    <h3>Proxy設定作成<span class="revobr-icon"></span><span class="revodt-icon"></span></h3>
  </div>


  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/proxy_settings') }}'">戻る</button>

  {{ Form::open(['action' => 'ProxySettingController@store']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray col-md-3">設定名 <span style="color: red">*</span></th>
      <td>PROXY_{{ Form::text('name', null, ['required' => 'required']) }}</td>
    </tr>
    <tr>
      <th class="gray">Proxyタイプ</th>
      <td>
        {{ Form::select('proxy_type', [1 => 'サーバ指定', 2 => 'PACファイル'])}}
      </td>
    </tr>
    <tr class="server">
      <th class="gray">Proxyホスト
        <span style="color: red">*</span>
      </th>
      <td>
        {{ Form::text('proxy_host', null) }}
      </td>
    </tr>
    <tr class="server">
      <th class="gray">Proxyポート <span style="color: red">*</span></th>
      <td>{{ Form::number('proxy_port', null, ['min' => 1, 'max' => 65535]) }}</td>
    </tr>
    <tr class="server">
      <th class="gray">Proxy例外</th>
      <td>{{ Form::text('proxy_exceptions', null) }}</td>
    </tr>
    <tr class="pac">
      <th class="gray">ProxyスクリプトURL
        <span style="color: red">*</span>
      </th>
      <td>
        {{ Form::text('proxy_script_url', null) }}
      </td>
    </tr>
  </table>
  {{ Form::submit('作成') }}
@stop

@section('script')
  <script src="{!! asset('js/tooltips.js') !!}"></script>
  <script src="{!! asset('js/scvmanager/proxy_settings.js') !!}"></script>
@stop
