<!-- scv/resources/views/proxy_settings/index.blade.php -->
@extends('layout.default')
@section('content')

  <div class="page-header">
    <h3>Proxy設定<span class="revobr-icon"></span><span class="revodt-icon"></span></h3>
  </div>

  <p>Proxy設定を管理します。</p>
  @if (Session::has('success'))
    <p class="text-info">{!! Session::get('success') !!}</p>
  @endif

  <button onclick="location.href='{{ URL::to('/scvmanager/scvgroups') }}'">戻る</button>
  <button onclick="location.href='{{ URL::to('/scvmanager/proxy_settings/create') }}'">作成</button>
  <div class="table-responsive">
    <table class="table table-condensed table-bordered table-striped">
      <tr>
        <th>id</th>
        <th>設定名</th>
        <th>Proxyタイプ</th>
        <th>Proxyホスト</th>
        <th>Proxyポート</th>
        <th>例外</th>
        <th>ProxyスクリプトURL</th>
      </tr>
      @foreach ($settings as $s)
        <tr>
          <td>{{ $s->id }}</td>
          <td><a href="{{ URL::to("/scvmanager/proxy_settings/$s->id") }}">{{ $s->name }}</a></td>
          <td>{{ $s->proxy_type_string }}</td>
          <td>{{ $s->proxy_host }}</td>
          <td>{{ $s->proxy_port }}</td>
          <td>{{ str_limit($s->proxy_exceptions, 20) }}</td>
          <td>{{ str_limit($s->proxy_script_url, 20) }}</td>
        </tr>
      @endforeach
    </table>
  </div>
@stop