<!-- scv/resources/views/proxy_settings/show.blade.php -->
@extends('layout.default')
@section('content')

  <div class="page-header">
    <h3>Proxy設定詳細<span class="revobr-icon"></span><span class="revodt-icon"></span></h3>
  </div>

  @if ($errors->any())
    @foreach ($errors->all() as $error)
      <p style="color:red">{{ $error }}</p>
    @endforeach
  @endif

  {{ Form::open(['url' => "/scvmanager/proxy_settings/{$setting->id}", 'method' => 'delete']) }}
  <button type="button" onclick="location.href='{{ URL::to('/scvmanager/proxy_settings') }}'">戻る</button>
  <button type="button" onclick="location.href='/scvmanager/proxy_settings/{{ $setting->id }}/edit'">編集</button>
  {{ Form::hidden('id', $setting->id) }}
  {{ Form::submit('削除', ['onclick' => 'return check();']) }}

  <table class="table table-condensed table-bordered">
    <tr>
      <th class="gray">設定名</th>
      <td>{{ $setting->name }}</td>
    </tr>
    <tr>
      <th class="gray">Proxyタイプ</th>
      <td>{{ $setting->proxy_type_string }}</td>
    </tr>
    @if($setting->proxy_type == 1)
      <tr>
        <th class="gray">Proxyホスト</th>
        <td>{{ $setting->proxy_host }}</td>
      </tr>
      <tr>
        <th class="gray">Proxyポート</th>
        <td>{{ $setting->proxy_port }}</td>
      </tr>
      <tr>
        <th class="gray">Proxy例外</th>
        <td>{{ $setting->proxy_exceptions,20 }}</td>
      </tr>
    @elseif($setting->proxy_type == 2)
      <tr>
        <th class="gray">ProxyスクリプトURL</th>
        <td>{{ $setting->proxy_script_url }}</td>
      </tr>
    @endif
  </table>
@stop

@section('script')
  <script>
    $(function() {
      $("form").submit(function() {
        if (confirm("{{ $setting->name }}を削除しますか？")) {
          return true;
        } else {
          return false;
        }
      });
    });

  </script>
@stop
