<!-- scv/resources/views/reports/newgraph.blade.php -->
@extends('layout.default')
@section('head')
<link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
<link rel="stylesheet" href="{!! asset('css/search-box.css') !!}">
@stop
@section('content')

<div class="page-header">
  <h3>ユーザ利用状況レポート（新）</h3>
</div>
<p>ユーザの利用状況に関するレポートです。</p>
{{--
<div class="panel panel-default" id="util-panel">
  <div class="panel-heading" id="form-header">
    <p class="table-title">期間と間隔を指定</p>
    <span class="glyphicon glyphicon-question-sign text-info" id="name_pop" data-toggle="popover" title="グラフ出力時の注意" data-content="<small>期間は3か月以内で指定してください。<br/>指定期間が長かったり、区切り時間が短いとグラフ出力に時間がかかる場合があります。</small>"></span>
  </div>
  <table class="table">
    <tbody>
      <form action="/scvmanager/reportutil" method="post" id="Graphform">
        <tr>
          <input type="hidden" name="_token" value="{{ csrf_token() }}">
          <td class="col-md-1"><p>期間</p></td>
          <td class="col-md-6">
            <div class="search-box" style="margin: 0px">
              {{ Form::text('start_date', $start_date, ['class' => 'datetime', 'readonly']) }} ～
              {{ Form::text('end_date', $end_date, ['class' => 'datetime', 'readonly']) }}
            </div>
          </td>
          <td class="col-md-1"><p>区切り時間</p></td>
          <td class="col-md-3">
            <select name="divide_time">
              <option value="5" @if($divide_time == 5) selected @endif >5分</option>
              <option value="10" @if($divide_time == 10) selected @endif >10分</option>
              <option value="15" @if($divide_time == 15) selected @endif >15分</option>
              <option value="30" @if($divide_time == 30) selected @endif >30分</option>
              <option value="60" @if($divide_time == 60) selected @endif >1時間</option>
              <option value="180" @if($divide_time == 180) selected @endif >3時間</option>
              <option value="360" @if($divide_time == 360) selected @endif >6時間</option>
              <option value="720" @if($divide_time == 720) selected @endif >12時間</option>
              <option value="1440" @if($divide_time == 1440) selected @endif >24時間</option>
            </select>
          </td>
        </tr>
        <tr>
          <td class="col-md-1"><p>グラフ1</p></td>
            <td class="col-md-5">
            <select name="selected_line1">
              <option value="1" @if($selected_line1 == 1) selected @endif >最大同時接続数</option>
              <option value="2" @if($selected_line1 == 2) selected @endif >総ログイン回数（失敗含む）/ログイン成功回数</option>
              <option value="3" @if($selected_line1 == 3) selected @endif >平均クライアント起動時間</option>
              <option value="4" @if($selected_line1 == 4) selected @endif >平均利用時間</option>
              <option value="5" @if($selected_line1 == 5) selected @endif >エラー回数</option>
              <option value="6" @if($selected_line1 == 6) selected @endif >エラー率</option>
            </select>
          </td>
          <td class="col-md-1"><p>グラフ2</p></td>
            <td class="col-md-5">
            <select name="selected_line2">
              <option value="1" @if($selected_line2 == 1) selected @endif >最大同時接続数</option>
              <option value="2" @if($selected_line2 == 2) selected @endif >総ログイン回数（失敗含む）/ログイン成功回数</option>
              <option value="3" @if($selected_line2 == 3) selected @endif >平均クライアント起動時間</option>
              <option value="4" @if($selected_line2 == 4) selected @endif >平均利用時間</option>
              <option value="5" @if($selected_line2 == 5) selected @endif >エラー回数</option>
              <option value="6" @if($selected_line2 == 6) selected @endif >エラー率</option>
            </select>
          </td>
        </tr>
        <tr id="Graph_scale">
          <td colspan="2" class="td-scale">
            <p><label for="scaleflg1">グラフ1のスケールを任意に設定</label><input id="scaleflg1" type="checkbox" name="scaleflg1"></p>
            <div class="scale-max"></div>
            <td colspan="2" class="td-scale">
            <p><label for="scaleflg2">グラフ2のスケールを任意に設定</label><input id="scaleflg2" type="checkbox" name="scaleflg2"></p>
            <div class="scale-max"></div>
            </td>
          </tr>
        <tr>
          @if(!empty($clusterservers))
            <td td class="td_serv" colspan="2"><p>サーバを選択</p>
              <select name="server">
                <option value="all" @if($selected_server == 'all') selected @endif >すべてのサーバ</option>
                @foreach($clusterservers as $clusterserver)
                  <option value="{{$clusterserver["ipaddress"]}}" @if($selected_server == $clusterserver["ipaddress"]) selected @endif >{{$clusterserver["hostname"]}}({{$clusterserver["ipaddress"]}})</option>
                @endforeach
              </select>
            </td>
            <td colspan="2">
          @else
            <td colspan="4">
            <input type="hidden" name="server" value="all"/>
          @endif
            <input id="submit-button" type="submit" name="request" value="グラフを作成する" >
          </td>
        </tr>
      </form>
    </tbody>
  </table>
</div>
--}}
<!--ローディング画面-->
<div class="modal" id="modal-loading" tabindex="-1">
  <div class="modal-dialog modal-sm">
    <div class="modal-content" style="border: 0; box-shadow: none; background: none; padding-top: 50%; position: 'fixed';">
      <div class="modal-body">
        <img src='{{asset("/images/loading.gif")}}' style="height: 200px; width: 200px;">
      </div>
    </div>
  </div>
</div>
<!--ローディング画面ここまで-->
<!--グラフ表示領域-->
<div id="wrap">
  <div id="div-result"></div>
  <div id="div-line1"></div>
  <div id="div-line2"></div>
</div>
<!--グラフ表示領域ここまで-->

<button type="button" onclick="history.back()">戻る</button>
@stop

@section('script')
<script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
<script src="{!! asset('js/search-box.js') !!}"></script>
{{--<script src="{!! asset('js/scvmanager/reportutil.js') !!}"></script>--}}
@stop