<!-- scv/resources/views/reports/reportrank.blade.php -->
@extends('layout.default')
@section('head')
<link rel="stylesheet" href="{!! asset('css/jquery.datetimepicker.css') !!}" />
<link rel="stylesheet" href="{!! asset('css/search-box.css') !!}">
@stop
@section('content')
<div class="page-header">
  <h3>ユーザランキング</h3>
</div>
<br/>
<div class="panel panel-default">
  <div class="panel-heading">
    <p class="table-title">期間と表示上限人数を指定</p>
  </div>
  {{ Form::open(['method' => 'post'], ['class' => 'Rankform']) }}
    <table class="table">
      <tbody>
        <tr>
          <td class="col-md-7">
              <div class="search-box">
                期間 :
                {{ Form::text('start_date', $start_date, ['class' => 'datetime', 'readonly']) }} ～
                {{ Form::text('end_date', $end_date, ['class' => 'datetime', 'readonly']) }}
              </div>
          </td>
          <td class="col-md-4">
            表示上限人数:
            <select name="number_of_user">
              <option value="20" @if($number_of_user == 20) selected @endif>20</option>
              <option value="50" @if($number_of_user == 50) selected @endif>50</option>
              <option value="100" @if($number_of_user == 100) selected @endif>100</option>
              <option value="200" @if($number_of_user == 200) selected @endif>200</option>
              <option value="300" @if($number_of_user == 300) selected @endif>300</option>
              <option value="500" @if($number_of_user == 500) selected @endif>500</option>
            </select>
            人
          </td>
        </tr>
        <tr>
          <td colspan="2" class="col-md-11">
            {{ Form::submit('この条件でランキングを作成する', ['name' => 'request']) }}
          </td>
        </tr>
      </tbody>
    </table>
  {{ Form::close() }}
</div>

<h4>ユーザログイン回数</h4>
<table class="table table-striped table-bordered">
<tr>
  <th class="cols">順位</th>
  <th class="cols">ユーザ名</th>
  <th class="cols">ログイン回数</th>
  <th class="cols">最終ログイン日時</th>
</tr>
@for($i = 0; $i < min($number_of_user,count($user_rank_return)); $i++)
  <tr>
    <td>{{$i+1}}</td>
    <td>{{$user_rank_return[$i]->organization_name}}/{{$user_rank_return[$i]->scvuser}}</td>
    <td>{{$user_rank_return[$i]->users_number}}</td>
    <td>{{$user_rank_return[$i]->last_login}}</td>
  </tr>
@endfor
</table>

<button type="button" onclick="history.back()">戻る</button>
@stop
@section('script')
<script src="{!! asset('js/jquery.datetimepicker.full.min.js') !!}"></script>
<script src="{!! asset('js/search-box.js') !!}"></script>
@stop